/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.Approval;
import com.silanis.esl.api.model.FieldSubtype;
import com.silanis.esl.api.model.FieldType;
import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.api.model.User;
import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.SignatureStyle;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.internal.ConversionException;
import com.silanis.esl.sdk.internal.converter.ConversionService;
import com.silanis.esl.sdk.internal.converter.FieldConverter;
import com.silanis.esl.sdk.internal.converter.TextAnchorConverter;

public class SignatureConverter {
    private Signature sdkSignature = null;
    private Approval apiApproval = null;
    private Package apiPackage = null;

    public SignatureConverter(Approval apiApproval, Package apiPackage) {
        this.apiApproval = apiApproval;
        this.apiPackage = apiPackage;
    }

    public SignatureConverter(Signature sdkSignature) {
        this.sdkSignature = sdkSignature;
    }

    public Signature toSDKSignature() {
        if (this.apiPackage == null || this.apiApproval == null) {
            return this.sdkSignature;
        }
        User apiSigner = null;
        for (Role role : this.apiPackage.getRoles()) {
            if (!role.getId().equals(this.apiApproval.getRole()) || SignatureConverter.isPlaceholder(role)) continue;
            apiSigner = role.getSigners().get(0);
        }
        SignatureBuilder signatureBuilder = SignatureBuilder.signatureFor(apiSigner != null ? apiSigner.getEmail() : "");
        signatureBuilder.withName(this.apiApproval.getName());
        com.silanis.esl.api.model.Field apiSignatureField = null;
        for (com.silanis.esl.api.model.Field apiField : this.apiApproval.getFields()) {
            if (apiField.getType() == FieldType.SIGNATURE) {
                apiSignatureField = apiField;
                continue;
            }
            signatureBuilder.withField(new FieldConverter(apiField).toSDKField());
        }
        if (apiSignatureField == null) {
            signatureBuilder.withStyle(SignatureStyle.ACCEPTANCE);
            signatureBuilder.withSize(0.0, 0.0);
        } else {
            signatureBuilder.withStyle(SignatureStyle.fromAPIFieldSubType(apiSignatureField.getSubtype()));
            signatureBuilder.onPage(apiSignatureField.getPage());
            signatureBuilder.atPosition(apiSignatureField.getLeft(), apiSignatureField.getTop());
            signatureBuilder.withSize(apiSignatureField.getWidth(), apiSignatureField.getHeight());
            if (apiSignatureField.evalExtract()) {
                signatureBuilder.withPositionExtracted();
            }
        }
        return signatureBuilder.build();
    }

    public Approval toAPIApproval() {
        if (this.sdkSignature == null) {
            return this.apiApproval;
        }
        Approval result = new Approval();
        result.addField(this.getAPIFieldFromSignature());
        for (Field field : this.sdkSignature.getFields()) {
            result.addField(ConversionService.convert(field));
        }
        return result;
    }

    private static boolean isPlaceholder(Role role) {
        return role.getSigners().isEmpty();
    }

    private com.silanis.esl.api.model.Field getAPIFieldFromSignature() {
        com.silanis.esl.api.model.Field result = new com.silanis.esl.api.model.Field();
        result.setPage(this.sdkSignature.getPage());
        result.setExtract(this.sdkSignature.isExtraction());
        if (this.sdkSignature.getName() != null) {
            result.setName(this.sdkSignature.getName());
        }
        if (!this.sdkSignature.isExtraction()) {
            result.setTop(this.sdkSignature.getY());
            result.setLeft(this.sdkSignature.getX());
            result.setWidth(this.sdkSignature.getWidth());
            result.setHeight(this.sdkSignature.getHeight());
        }
        if (this.sdkSignature.getTextAnchor() != null) {
            result.setExtractAnchor(new TextAnchorConverter(this.sdkSignature.getTextAnchor()).toAPIExtractAnchor());
        }
        result.setType(FieldType.SIGNATURE);
        result.setSubtype(this.getSignatureSubtype());
        return result;
    }

    private FieldSubtype getSignatureSubtype() {
        switch (this.sdkSignature.getStyle()) {
            case FULL_NAME: {
                return FieldSubtype.FULLNAME;
            }
            case HAND_DRAWN: {
                return FieldSubtype.CAPTURE;
            }
            case INITIALS: {
                return FieldSubtype.INITIALS;
            }
            case ACCEPTANCE: {
                return FieldSubtype.FULLNAME;
            }
        }
        throw new ConversionException(Signature.class, Approval.class, "Unable to decode signature type.");
    }
}

