/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.Delivery;
import com.silanis.esl.api.model.Group;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.internal.converter.AuthenticationConverter;

public class SignerConverter {
    private Signer sdkSigner = null;
    private com.silanis.esl.api.model.Signer apiSigner = null;
    private Role apiRole = null;

    public SignerConverter(Role apiRole) {
        this.apiRole = apiRole;
        if (apiRole != null) {
            this.apiSigner = apiRole.getSigners().get(0);
        }
    }

    public SignerConverter(Signer sdkSigner) {
        this.sdkSigner = sdkSigner;
    }

    public com.silanis.esl.api.model.Signer toAPISigner() {
        if (this.sdkSigner == null) {
            return this.apiSigner;
        }
        com.silanis.esl.api.model.Signer result = new com.silanis.esl.api.model.Signer();
        if (!this.sdkSigner.isGroupSigner()) {
            result.setEmail(this.sdkSigner.getEmail()).setFirstName(this.sdkSigner.getFirstName()).setLastName(this.sdkSigner.getLastName()).setTitle(this.sdkSigner.getTitle()).setCompany(this.sdkSigner.getCompany()).setDelivery(new Delivery().setEmail(this.sdkSigner.isDeliverSignedDocumentsByEmail()));
        } else {
            result.setGroup(new Group().setId(this.sdkSigner.getGroupId().toString()));
        }
        if (this.sdkSigner.getId() != null) {
            result.setId(this.sdkSigner.getId());
        }
        result.setAuth(new AuthenticationConverter(this.sdkSigner.getAuthentication()).toAPIAuthentication());
        return result;
    }

    public Signer toSDKSigner() {
        SignerBuilder signerBuilder;
        if (this.apiRole == null) {
            return this.sdkSigner;
        }
        if (this.apiSigner.getGroup() == null) {
            signerBuilder = SignerBuilder.newSignerWithEmail(this.apiSigner.getEmail()).withFirstName(this.apiSigner.getFirstName()).withLastName(this.apiSigner.getLastName()).withCompany(this.apiSigner.getCompany()).withTitle(this.apiSigner.getTitle());
            if (this.apiSigner.getDelivery() != null && this.apiSigner.getDelivery().getEmail().booleanValue()) {
                signerBuilder.deliverSignedDocumentsByEmail();
            }
        } else {
            signerBuilder = SignerBuilder.newSignerFromGroup(new GroupId(this.apiSigner.getGroup().getId()));
        }
        signerBuilder.withCustomId(this.apiSigner.getId()).withRoleId(this.apiRole.getId()).signingOrder(this.apiRole.getIndex());
        if (this.apiRole.evalReassign()) {
            signerBuilder.canChangeSigner();
        }
        if (this.apiRole.getEmailMessage() != null) {
            signerBuilder.withEmailMessage(this.apiRole.getEmailMessage().getContent());
        }
        if (this.apiRole.getLocked().booleanValue()) {
            signerBuilder.lock();
        }
        return signerBuilder.build();
    }
}

