/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.ExtractAnchor;
import com.silanis.esl.sdk.TextAnchor;
import com.silanis.esl.sdk.TextAnchorPosition;

public class TextAnchorConverter {
    private TextAnchor sdkTextAnchor = null;
    private ExtractAnchor extractAnchor = null;

    public TextAnchorConverter(TextAnchor textAnchor) {
        this.sdkTextAnchor = textAnchor;
    }

    public TextAnchorConverter(ExtractAnchor extractAnchor) {
        this.extractAnchor = extractAnchor;
    }

    public ExtractAnchor toAPIExtractAnchor() {
        if (this.sdkTextAnchor == null) {
            return this.extractAnchor;
        }
        ExtractAnchor result = new ExtractAnchor();
        result.setLeftOffset(this.sdkTextAnchor.getXOffset());
        result.setTopOffset(this.sdkTextAnchor.getYOffset());
        result.setText(this.sdkTextAnchor.getAnchorText());
        result.setIndex(this.sdkTextAnchor.getOccurrence());
        result.setCharacterIndex(this.sdkTextAnchor.getCharacter());
        result.setAnchorPoint(this.sdkTextAnchor.getPosition().toString());
        result.setWidth(this.sdkTextAnchor.getWidth());
        result.setHeight(this.sdkTextAnchor.getHeight());
        return result;
    }

    public TextAnchor toSDKTextAnchor() {
        if (this.extractAnchor == null) {
            return this.sdkTextAnchor;
        }
        TextAnchor result = new TextAnchor();
        result.setPosition(TextAnchorPosition.valueOf(this.extractAnchor.getAnchorPoint()));
        result.setOccurrence(this.extractAnchor.getIndex());
        result.setAnchorText(this.extractAnchor.getText());
        result.setCharacter(this.extractAnchor.getCharacterIndex());
        result.setXOffset(this.extractAnchor.getLeftOffset());
        result.setYOffset(this.extractAnchor.getTopOffset());
        result.setWidth(this.extractAnchor.getWidth());
        result.setHeight(this.extractAnchor.getHeight());
        return result;
    }
}

