/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.User;
import com.silanis.esl.sdk.AccountMember;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.AccountMemberConverter;

public class AccountService {
    private UrlTemplate template;
    private RestClient client;

    public AccountService(RestClient client, String baseUrl) {
        this.template = new UrlTemplate(baseUrl);
        this.client = client;
    }

    public void inviteUser(AccountMember accountMember) {
        String path = this.template.urlFor("/account/senders").build();
        User user = new AccountMemberConverter(accountMember).toAPIUser();
        try {
            this.client.post(path, Serialization.toJson(user));
        }
        catch (Exception e) {
            throw new EslException("Unable to invite member to account.", e);
        }
    }
}

