/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.silanis.esl.sdk.Audit;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.UrlTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AuditService {
    private final UrlTemplate template;
    private final RestClient client;

    public AuditService(RestClient client, String baseUrl) {
        this.template = new UrlTemplate(baseUrl);
        this.client = client;
    }

    public List<Audit> getAudit(PackageId packageId) throws EslException {
        List<Audit> auditList;
        String path = this.template.urlFor("/packages/{packageId}/audit").replace("{packageId}", packageId.getId()).build();
        try {
            String stringResponse = this.client.get(path);
            auditList = this.mapToAudit(stringResponse);
        }
        catch (Exception e) {
            throw new EslException("Could not get audit.", e);
        }
        return auditList;
    }

    private List<Audit> mapToAudit(String stringResponse) throws IOException {
        ArrayList<Audit> auditList = new ArrayList<Audit>();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(stringResponse);
        if (jsonNode.has("audit-events")) {
            int i = 0;
            while (jsonNode.get("audit-events").has(i)) {
                JsonNode event = jsonNode.get("audit-events").get(i);
                Audit audit = new Audit(event.get("type").asText(), event.get("date-time").asText(), event.get("target").asText(), event.get("user").asText(), event.get("user-email").asText(), event.get("user-ip").asText(), event.get("data").asText());
                auditList.add(audit);
                ++i;
            }
        }
        return auditList;
    }
}

