/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.UserCustomField;
import com.silanis.esl.sdk.CustomField;
import com.silanis.esl.sdk.CustomFieldValue;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.CustomFieldConverter;
import com.silanis.esl.sdk.internal.converter.CustomFieldValueConverter;

public class CustomFieldService {
    private UrlTemplate template;
    private RestClient client;

    public CustomFieldService(RestClient client, String baseUrl) {
        this.template = new UrlTemplate(baseUrl);
        this.client = client;
    }

    public CustomField createCustomField(CustomField customField) throws EslException {
        String path = this.template.urlFor("/account/customfields").build();
        CustomField sdkResponse = null;
        try {
            if (this.doesCustomFieldExist(customField.getId())) {
                com.silanis.esl.api.model.CustomField apiRequest = new CustomFieldConverter(customField).toAPICustomField();
                String stringResponse = this.client.put(path, Serialization.toJson(apiRequest));
                com.silanis.esl.api.model.CustomField apiResponse = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.CustomField.class);
                sdkResponse = new CustomFieldConverter(apiResponse).toSDKCustomField();
            } else {
                com.silanis.esl.api.model.CustomField apiRequest = new CustomFieldConverter(customField).toAPICustomField();
                String stringResponse = this.client.post(path, Serialization.toJson(apiRequest));
                com.silanis.esl.api.model.CustomField apiResponse = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.CustomField.class);
                sdkResponse = new CustomFieldConverter(apiResponse).toSDKCustomField();
            }
            return sdkResponse;
        }
        catch (Exception e) {
            throw new EslException("Could not add/update the custom field to account.", e);
        }
    }

    public boolean doesCustomFieldExist(String id) {
        String path = this.template.urlFor("/account/customfields").build();
        path = path + "/" + id;
        try {
            String stringResponse = this.client.get(path);
            if (stringResponse == null || stringResponse.isEmpty()) {
                return false;
            }
            Serialization.fromJson(stringResponse, CustomFieldValue.class);
            return true;
        }
        catch (EslException e) {
            return false;
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom field from account.", e);
        }
    }

    public CustomFieldValue submitCustomFieldValue(CustomFieldValue customFieldValue) throws EslException {
        String path = this.template.urlFor("/user/customfields").build();
        try {
            String payload = Serialization.toJson(new CustomFieldValueConverter(customFieldValue).toAPIUserCustomField());
            String response = this.doesCustomFieldValueExist(customFieldValue.getId()) ? this.client.put(path, payload) : this.client.post(path, payload);
            UserCustomField result = Serialization.fromJson(response, UserCustomField.class);
            return new CustomFieldValueConverter(customFieldValue).toSDKCustomFieldValue();
        }
        catch (Exception e) {
            throw new EslException("Could not add/update the custom field to account.", e);
        }
    }

    public boolean doesCustomFieldValueExist(String id) {
        String path = this.template.urlFor("/user/customfields").build();
        path = path + "/" + id;
        try {
            String stringResponse = this.client.get(path);
            if (stringResponse == null || stringResponse.isEmpty()) {
                return false;
            }
            Serialization.fromJson(stringResponse, UserCustomField.class);
            return true;
        }
        catch (EslException e) {
            return false;
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom field from user.", e);
        }
    }
}

