/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.Callback;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.EventNotificationConfig;
import com.silanis.esl.sdk.builder.EventNotificationConfigBuilder;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;

public class EventNotificationService {
    private final UrlTemplate template;
    private final RestClient client;

    public EventNotificationService(RestClient client, String baseUrl) {
        this.template = new UrlTemplate(baseUrl);
        this.client = client;
    }

    public void register(EventNotificationConfig config) {
        String path = this.template.urlFor("/callback").build();
        Callback callback = config.toAPICallback();
        String packageJson = Serialization.toJson(callback);
        try {
            this.client.post(path, packageJson);
        }
        catch (Exception rootException) {
            throw new EslException("Unable to register for event notification.", rootException);
        }
    }

    public void register(EventNotificationConfigBuilder builder) {
        this.register(builder.build());
    }
}

