/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.FieldSummary;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import java.util.List;

public class FieldSummaryService {
    private UrlTemplate template;
    private RestClient client;

    public FieldSummaryService(RestClient client, String baseUrl) {
        this.template = new UrlTemplate(baseUrl);
        this.client = client;
    }

    public List<FieldSummary> getFieldSummary(PackageId packageId) throws EslException {
        List<FieldSummary> fieldSummary;
        String path = this.template.urlFor("/packages/{packageId}/fieldSummary").replace("{packageId}", packageId.getId()).build();
        try {
            String stringResponse = this.client.get(path);
            fieldSummary = Serialization.fromJsonToList(stringResponse, FieldSummary.class);
        }
        catch (Exception e) {
            throw new EslException("Could not get the field summary.", e);
        }
        return fieldSummary;
    }
}

