/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.silanis.esl.api.model.Result;
import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.Group;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.GroupMember;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.GroupConverter;
import com.silanis.esl.sdk.internal.converter.GroupMemberConverter;
import java.util.ArrayList;
import java.util.List;

public class GroupService {
    private UrlTemplate template;
    private RestClient client;

    public GroupService(RestClient client, String baseUrl) {
        this.client = client;
        this.template = new UrlTemplate(baseUrl);
    }

    public List<Group> getMyGroups() {
        String path = this.template.urlFor("/groups").build();
        try {
            String stringResponse = this.client.get(path);
            Result<com.silanis.esl.api.model.Group> apiResponse = JacksonUtil.deserialize(stringResponse, new TypeReference<Result<com.silanis.esl.api.model.Group>>(){});
            ArrayList<Group> result = new ArrayList<Group>();
            for (com.silanis.esl.api.model.Group apiGroup : apiResponse.getResults()) {
                result.add(new GroupConverter(apiGroup).toSDKGroup());
            }
            return result;
        }
        catch (Exception e) {
            throw new EslException("Failed to retrieve Groups list.", e);
        }
    }

    public Group getGroup(GroupId groupId) {
        String path = this.template.urlFor("/groups/{groupId}").replace("{groupId}", groupId.getId()).build();
        try {
            String stringResponse = this.client.get(path);
            com.silanis.esl.api.model.Group apiResponse = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.Group.class);
            return new GroupConverter(apiResponse).toSDKGroup();
        }
        catch (Exception e) {
            throw new EslException("Failed to retrieve Group.", e);
        }
    }

    public Group createGroup(Group group) {
        String path = this.template.urlFor("/groups").build();
        com.silanis.esl.api.model.Group apiGroup = new GroupConverter(group).toAPIGroupWithoutMembers();
        try {
            String stringResponse = this.client.post(path, Serialization.toJson(apiGroup));
            com.silanis.esl.api.model.Group apiResponse = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.Group.class);
            Group resultGroup = new GroupConverter(apiResponse).toSDKGroup();
            for (GroupMember groupMember : group.getMembers()) {
                this.inviteMember(resultGroup.getId(), groupMember);
            }
            return resultGroup;
        }
        catch (Exception e) {
            throw new EslException("Unable to create Group.", e);
        }
    }

    public GroupMember inviteMember(GroupId groupId, GroupMember groupMember) {
        String path = this.template.urlFor("/groups/{groupId}/members").build().replace("{groupId}", groupId.getId());
        com.silanis.esl.api.model.GroupMember apiGroupMember = new GroupMemberConverter(groupMember).toAPIGroupMember();
        try {
            String stringResponse = this.client.post(path, Serialization.toJson(apiGroupMember));
            com.silanis.esl.api.model.GroupMember apiResponse = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.GroupMember.class);
            GroupMember resultGroupMember = new GroupMemberConverter(apiResponse).toSDKGroupMember();
            return resultGroupMember;
        }
        catch (Exception e) {
            throw new EslException("Unable to invite member to group.", e);
        }
    }

    public void deleteGroup(GroupId groupId) {
        String path = this.template.urlFor("/groups/{groupId}").replace("{groupId}", groupId.getId()).build();
        try {
            this.client.delete(path);
        }
        catch (Exception e) {
            throw new EslException("Failed to delete Group.", e);
        }
    }

    public List<String> getGroupMemberEmails(GroupId groupId) {
        ArrayList<String> result = null;
        Group group = this.getGroup(groupId);
        if (group != null) {
            result = new ArrayList<String>();
            for (GroupMember groupMember : group.getMembers()) {
                result.add(groupMember.getEmail());
            }
        }
        return result;
    }

    public List<GroupMember> getGroupMembers(GroupId groupId) {
        List<GroupMember> result = null;
        Group group = this.getGroup(groupId);
        if (group != null) {
            result = group.getMembers();
        }
        return result;
    }
}

