/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.silanis.esl.api.model.Document;
import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.PackageStatus;
import com.silanis.esl.api.model.Result;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.api.model.Signer;
import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.DocumentId;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Page;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.RoleList;
import com.silanis.esl.sdk.SignerId;
import com.silanis.esl.sdk.SigningStatus;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.DocumentPackageConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PackageService {
    private UrlTemplate template;
    private RestClient client;

    public PackageService(RestClient client, String baseUrl) {
        this.client = client;
        this.template = new UrlTemplate(baseUrl);
    }

    public PackageId createPackage(Package aPackage) throws EslException {
        String path = this.template.urlFor("/packages").build();
        String packageJson = Serialization.toJson(aPackage);
        try {
            String response = this.client.post(path, packageJson);
            return Serialization.fromJson(response, PackageId.class);
        }
        catch (Exception e) {
            throw new EslException("Could not create a new package", e);
        }
    }

    public PackageId createPackageFromTemplate(PackageId packageId, Package aPackage) {
        String path = this.template.urlFor("/packages/{packageId}/clone").replace("{packageId}", packageId.getId()).build();
        List<Role> roles = aPackage.getRoles();
        aPackage.setRoles(Collections.emptyList());
        String packageJson = Serialization.toJson(aPackage);
        PackageId newPackageId = null;
        try {
            String response = this.client.post(path, packageJson);
            newPackageId = Serialization.fromJson(response, PackageId.class);
        }
        catch (Exception e) {
            throw new EslException("Could not create a new package", e);
        }
        Package createdPackage = this.getPackage(newPackageId);
        for (Role role : roles) {
            String roleUid = this.findRoleUidByName(createdPackage.getRoles(), role.getName());
            if (roleUid == null) continue;
            role.setId(roleUid);
            this.updateRole(newPackageId, role);
        }
        return newPackageId;
    }

    private String findRoleUidByName(List<Role> roles, String roleName) {
        if (roleName == null || roleName.trim().isEmpty()) {
            return null;
        }
        for (Role role : roles) {
            if (!roleName.equalsIgnoreCase(role.getName())) continue;
            return role.getId();
        }
        return null;
    }

    public void updatePackage(PackageId packageId, Package aPackage) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        String packageJson = Serialization.toJson(aPackage);
        try {
            this.client.post(path, packageJson);
        }
        catch (Exception e) {
            throw new EslException("Could not update the package.", e);
        }
        List<Role> roleList = aPackage.getRoles();
        for (Role role : roleList) {
            this.updateRole(packageId, role);
        }
    }

    public Package getPackage(PackageId packageId) throws EslException {
        String stringResponse;
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        try {
            stringResponse = this.client.get(path);
        }
        catch (Exception e) {
            throw new EslException("Could not get package.", e);
        }
        return Serialization.fromJson(stringResponse, Package.class);
    }

    public void uploadDocument(PackageId packageId, String fileName, byte[] fileBytes, Document document) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents").replace("{packageId}", packageId.getId()).build();
        String documentJson = Serialization.toJson(document);
        try {
            this.client.postMultipartFile(path, fileName, fileBytes, documentJson);
        }
        catch (Exception e) {
            throw new EslException("Could not upload document to package.", e);
        }
    }

    public void deleteDocument(PackageId packageId, Document document) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}").replace("{packageId}", packageId.getId()).replace("{documentId}", document.getId()).build();
        try {
            this.client.delete(path);
        }
        catch (Exception e) {
            throw new EslException("Could not delete document from package.", e);
        }
    }

    public void sendPackage(PackageId packageId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        String json = "{\"status\":\"SENT\"}";
        try {
            this.client.post(path, json);
        }
        catch (Exception e) {
            throw new EslException("Could not send the package.", e);
        }
    }

    public List<Role> getRoles(PackageId packageId) throws EslException {
        String stringResponse;
        String path = this.template.urlFor("/packages/{packageId}/roles").replace("{packageId}", packageId.getId()).build();
        try {
            stringResponse = this.client.get(path);
        }
        catch (Exception e) {
            throw new EslException("Could not retrieve list of roles for package with id " + packageId.getId(), e);
        }
        return Serialization.fromJson(stringResponse, RoleList.class).getResults();
    }

    public Role addRole(PackageId packageId, Role role) throws EslException {
        String stringResponse;
        String path = this.template.urlFor("/packages/{packageId}/roles").replace("{packageId}", packageId.getId()).build();
        String roleJson = JacksonUtil.serializeDirty(role);
        try {
            stringResponse = this.client.post(path, roleJson);
        }
        catch (Exception e) {
            throw new EslException("Could not add role.", e);
        }
        return Serialization.fromJson(stringResponse, Role.class);
    }

    public Role updateRole(PackageId packageId, Role role) throws EslException {
        String stringResponse;
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}").replace("{packageId}", packageId.getId()).replace("{roleId}", role.getId()).build();
        String roleJson = JacksonUtil.serializeDirty(role);
        try {
            stringResponse = this.client.put(path, roleJson);
        }
        catch (Exception e) {
            throw new EslException("Could not update role", e);
        }
        return Serialization.fromJson(stringResponse, Role.class);
    }

    public void deleteRole(PackageId packageId, Role role) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}").replace("{packageId}", packageId.getId()).replace("{roleId}", role.getId()).build();
        try {
            this.client.delete(path);
        }
        catch (Exception e) {
            throw new EslException("Could not delete role", e);
        }
    }

    public byte[] downloadDocument(PackageId packageId, Document document) throws EslException {
        return this.downloadDocument(packageId, document.getId());
    }

    public byte[] downloadDocument(PackageId packageId, String documentId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/pdf").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).build();
        try {
            return this.client.getBytes(path);
        }
        catch (Exception e) {
            throw new EslException("Could not download the pdf document.", e);
        }
    }

    public byte[] downloadZippedDocuments(PackageId packageId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/zip").replace("{packageId}", packageId.getId()).build();
        try {
            return this.client.getBytes(path);
        }
        catch (Exception e) {
            throw new EslException("Could not download the documents to a zip file.", e);
        }
    }

    public byte[] downloadEvidenceSummary(PackageId packageId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/evidence/summary").replace("{packageId}", packageId.getId()).build();
        try {
            return this.client.getBytes(path);
        }
        catch (Exception e) {
            throw new EslException("Could not download the evidence summary.", e);
        }
    }

    public SigningStatus getSigningStatus(PackageId packageId, SignerId signerId, DocumentId documentId) {
        String path = this.template.urlFor("/packages/{packageId}/signingStatus?signer={signerId}&document={documentId}").replace("{packageId}", packageId.getId()).replace("{signerId}", signerId != null ? signerId.getId() : "").replace("{documentId}", documentId != null ? documentId.getId() : "").build();
        try {
            String stringResponse = this.client.get(path);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode topNode = objectMapper.readTree(stringResponse);
            String statusString = topNode.get("status").textValue();
            return SigningStatus.statusForToken(statusString);
        }
        catch (Exception e) {
            throw new EslException("Could not retrieve signing status.", e);
        }
    }

    public Page<DocumentPackage> getPackages(PackageStatus status, PageRequest request) {
        String path = this.template.urlFor("/packages?query={status}&from={from}&to={to}").replace("{status}", status.toString()).replace("{from}", Integer.toString(request.getFrom())).replace("{to}", Integer.toString(request.to())).build();
        try {
            String response = this.client.get(path);
            Result<Package> results = JacksonUtil.deserialize(response, new TypeReference<Result<Package>>(){});
            return this.convertToPage(results, request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EslException("Could not get package list. Exception: " + e.getMessage());
        }
    }

    private Page<DocumentPackage> convertToPage(Result<Package> results, PageRequest request) {
        ArrayList<DocumentPackage> converted = new ArrayList<DocumentPackage>();
        for (Package aPackage : results.getResults()) {
            DocumentPackage dp = new DocumentPackageConverter(aPackage).toSDKPackage();
            converted.add(dp);
        }
        return new Page<DocumentPackage>(converted, results.getCount(), request);
    }

    public void deletePackage(PackageId packageId) {
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        try {
            this.client.delete(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EslException("Unable to delete package. Exception: " + e.getMessage());
        }
    }

    public void notifySigner(PackageId packageId, String signerEmail, String message) {
        String path = this.template.urlFor("/packages/{packageId}/notifications").replace("{packageId}", packageId.getId()).build();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("email", signerEmail);
        jsonMap.put("message", message);
        try {
            String payload = JacksonUtil.serialize(jsonMap);
            this.client.post(path, payload);
        }
        catch (Exception e) {
            throw new EslException("Could not send email notification to signer. Exception: " + e.getMessage());
        }
    }

    private Role findRoleForGroup(PackageId packageId, String groupId) {
        List<Role> roles = this.getRoles(packageId);
        for (Role role : roles) {
            Signer signer;
            if (role.getSigners().isEmpty() || (signer = role.getSigners().get(0)).getGroup() == null || !signer.getGroup().getId().equals(groupId)) continue;
            return role;
        }
        return null;
    }

    public void notifySigner(PackageId packageId, GroupId groupId) {
        Role role = this.findRoleForGroup(packageId, groupId.getId());
        this.notifySigner(packageId, role.getId());
    }

    private void notifySigner(PackageId packageId, String roleId) {
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}/notifications").replace("{packageId}", packageId.getId()).replace("{roleId}", roleId).build();
        try {
            this.client.post(path, null);
        }
        catch (Exception e) {
            throw new EslException("Could not send email notification.  " + e.getMessage());
        }
    }

    public Page<DocumentPackage> getTemplates(PageRequest request) {
        String path = this.template.urlFor("/packages?type=template&from={from}&to={to}").replace("{from}", Integer.toString(request.getFrom())).replace("{to}", Integer.toString(request.to())).build();
        try {
            String response = this.client.get(path);
            Result<Package> results = JacksonUtil.deserialize(response, new TypeReference<Result<Package>>(){});
            return this.convertToPage(results, request);
        }
        catch (Exception e) {
            throw new EslException("Could not get template list. Exception: " + e.getMessage());
        }
    }
}

