/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.api.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.silanis.esl.api.util.JacksonUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SessionFields {
    public static final int MAX_LENGTH = 200;
    private static final String FIELD_SEPARATOR = ", ";
    private static final String KEY_VALUE_SEPARATOR = ": ";
    private Map<String, String> fields;

    public SessionFields() {
        this(new LinkedHashMap<String, String>());
    }

    public SessionFields(Map<String, String> fields) {
        this.fields = fields;
    }

    @JsonValue
    public Map<String, String> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, String> fields) {
        this.fields = fields;
    }

    @JsonAnySetter
    public void addField(String key, String value) {
        this.fields.put(key, value);
    }

    public String toString() {
        StringBuilder fieldStringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            fieldStringBuilder.append(entry.getKey()).append(KEY_VALUE_SEPARATOR).append(entry.getValue());
            if (!it.hasNext()) continue;
            fieldStringBuilder.append(FIELD_SEPARATOR);
        }
        return fieldStringBuilder.toString();
    }

    public String toJson() {
        return JacksonUtil.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionFields that = (SessionFields)o;
        return !(this.fields == null ? that.fields != null : !this.fields.equals(that.fields));
    }

    public int hashCode() {
        return this.fields != null ? this.fields.hashCode() : 0;
    }
}

