/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.DelegationUser;
import com.silanis.esl.sdk.Sender;
import java.util.Date;

public class DelegationUserBuilder {
    private String email;
    private String firstName;
    private String id;
    private String lastName;
    private String name;
    private Date expiryDate;

    private DelegationUserBuilder(String email) {
        this.email = email;
    }

    public static DelegationUserBuilder newDelegationUser(String email) {
        return new DelegationUserBuilder(email);
    }

    public static DelegationUserBuilder newDelegationUser(Sender sender) {
        return new DelegationUserBuilder(sender.getEmail()).withFirstName(sender.getFirstName()).withId(sender.getId()).withLastName(sender.getLastName()).withName(sender.getName());
    }

    public DelegationUserBuilder withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public DelegationUserBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public DelegationUserBuilder withLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public DelegationUserBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public DelegationUserBuilder withExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    public DelegationUser build() {
        DelegationUser result = new DelegationUser();
        result.setEmail(this.email);
        result.setFirstName(this.firstName);
        result.setId(this.id);
        result.setLastName(this.lastName);
        result.setName(this.name);
        return result;
    }
}

