/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.EslClient;
import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.apitoken.ApiTokenConfig;
import com.silanis.esl.sdk.examples.SDKSample;
import com.silanis.esl.sdk.internal.Converter;
import java.util.Collections;
import java.util.Map;

public abstract class SDKSampleWithRolesAndPermission
extends SDKSample {
    protected EslClient eslClientForRolesAndPermission;
    public String senderEmailForRolesAndPermission;
    public String senderSmsForRolesAndPermission;
    public String senderUIDForRolesAndPermission;

    public SDKSampleWithRolesAndPermission() {
        this.activateRolesAndPermissionProperties();
    }

    private void activateRolesAndPermissionProperties() {
        this.senderEmailForRolesAndPermission = this.props.getProperty("sender.email.WithRolesAndPermission");
        this.senderSmsForRolesAndPermission = this.props.getProperty("sender.sms.WithRolesAndPermission");
        this.senderUIDForRolesAndPermission = Converter.apiKeyToUID(this.props.getProperty("api.key.WithRolesAndPermission"));
        this.setupEslClientFromProps(Collections.<String, String>emptyMap(), null);
    }

    @Override
    public EslClient setupEslClientFromProps(Map<String, String> additionalHeaders, ProxyConfiguration proxyConfiguration) {
        if (this.props.getProperty("api.clientId.WithRolesAndPermission") == null) {
            this.eslClientForRolesAndPermission = new EslClient(this.props.getProperty("api.key.WithRolesAndPermission"), this.props.getProperty("api.url"), true, proxyConfiguration).setWebpageURL(this.props.getProperty("webpage.url"));
        } else {
            ApiTokenConfig apiTokenConfig = ApiTokenConfig.newBuilder().clientAppId(this.props.getProperty("api.clientId.WithRolesAndPermission")).clientAppSecret(this.props.getProperty("api.secret.WithRolesAndPermission")).tokenType(ApiTokenConfig.TokenType.OWNER).baseUrl(this.props.getProperty("webpage.url")).build();
            this.eslClientForRolesAndPermission = new EslClient(apiTokenConfig, this.props.getProperty("api.url"), true, proxyConfiguration, true, additionalHeaders);
        }
        return this.eslClientForRolesAndPermission;
    }
}

