/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.List;

public class SignableSignaturesExample
extends SDKSample {
    private DocumentPackage sentPackage;
    private String signer1Id = "signer1Id";
    private String signer2Id = "signer2Id";
    private String documentId = "documentId";
    public List<Signature> signer1SignableSignatures;
    public List<Signature> signer2SignableSignatures;

    public static void main(String ... args) {
        new SignableSignaturesExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using the eSignLive SDK").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John1").withLastName("Smith1").withCustomId(this.signer1Id)).withSigner(SignerBuilder.newSignerWithEmail(this.email2).withFirstName("John2").withLastName("Smith2").withCustomId(this.signer2Id)).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withId(this.documentId).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0)).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(300.0, 100.0)).withSignature(SignatureBuilder.signatureFor(this.email2).onPage(0).atPosition(500.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(this.packageId);
        this.sentPackage = this.eslClient.getPackage(this.packageId);
        this.signer1SignableSignatures = this.eslClient.getApprovalService().getAllSignableSignatures(this.sentPackage, this.documentId, this.signer1Id);
        this.signer2SignableSignatures = this.eslClient.getApprovalService().getAllSignableSignatures(this.sentPackage, this.documentId, this.signer2Id);
    }
}

