/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.SignatureId;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.ArrayList;
import java.util.Collection;
import org.joda.time.DateMidnight;

public class SignatureManipulationExample
extends SDKSample {
    public static final String DOCUMENT_NAME = "SignatureManipulationExample";
    public final String documentId = "documentId";
    private final SignatureId signatureId1 = new SignatureId("signatureId1");
    private final SignatureId signatureId2 = new SignatureId("signatureId2");
    private final SignatureId signatureId3 = new SignatureId("signatureId3");
    public Signature signature1;
    public Signature signature2;
    public Signature signature3;
    public Signature modifiedSignature;
    public Signature updatedSignature1;
    public Signature updatedSignature2;
    public Collection<Signature> addedSignatures;
    public Collection<Signature> deletedSignatures;
    public Collection<Signature> modifiedSignatures;
    public Collection<Signature> updatedSignatures;
    public DocumentPackage createdPackage;

    public static void main(String ... args) {
        new SignatureManipulationExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using the eSignLive SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("signer1").withFirstName("firstName1").withLastName("lastName1")).withSigner(SignerBuilder.newSignerWithEmail(this.email2).withCustomId("signer2").withFirstName("firstName2").withLastName("lastName2")).withSigner(SignerBuilder.newSignerWithEmail(this.email3).withCustomId("signer3").withFirstName("firstName3").withLastName("lastName3")).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT_NAME).fromStream(this.documentInputStream1, DocumentType.PDF).withId("documentId")).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.signature1 = SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0).withId(this.signatureId1).build();
        this.signature2 = SignatureBuilder.signatureFor(this.email2).onPage(0).atPosition(100.0, 200.0).withId(this.signatureId2).build();
        this.signature3 = SignatureBuilder.signatureFor(this.email3).onPage(0).atPosition(100.0, 300.0).withId(this.signatureId3).build();
        this.modifiedSignature = SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 300.0).withId(this.signatureId3).build();
        this.createdPackage = this.eslClient.getPackageService().getPackage(this.packageId);
        this.eslClient.getApprovalService().addSignature(this.createdPackage, "documentId", this.signature1);
        this.eslClient.getApprovalService().addSignature(this.createdPackage, "documentId", this.signature2);
        this.eslClient.getApprovalService().addSignature(this.createdPackage, "documentId", this.signature3);
        this.addedSignatures = this.eslClient.getPackage(this.packageId).getDocument(DOCUMENT_NAME).getSignatures();
        this.eslClient.getApprovalService().deleteSignature(this.packageId, "documentId", this.signatureId1);
        this.deletedSignatures = this.eslClient.getPackage(this.packageId).getDocument(DOCUMENT_NAME).getSignatures();
        this.createdPackage = this.eslClient.getPackageService().getPackage(this.packageId);
        this.eslClient.getApprovalService().modifySignature(this.createdPackage, "documentId", this.modifiedSignature);
        this.modifiedSignatures = this.eslClient.getPackage(this.packageId).getDocument(DOCUMENT_NAME).getSignatures();
        this.updatedSignature1 = SignatureBuilder.signatureFor(this.email2).onPage(0).atPosition(300.0, 300.0).withId(this.signatureId2).withField(FieldBuilder.signerName().atPosition(100.0, 100.0).onPage(0)).build();
        this.updatedSignature2 = SignatureBuilder.signatureFor(this.email3).onPage(0).atPosition(300.0, 500.0).withId(this.signatureId3).build();
        ArrayList<Signature> signatureList = new ArrayList<Signature>();
        signatureList.add(this.updatedSignature1);
        signatureList.add(this.updatedSignature2);
        this.eslClient.getApprovalService().updateSignatures(this.createdPackage, "documentId", signatureList);
        this.updatedSignatures = this.eslClient.getPackage(this.packageId).getDocument(DOCUMENT_NAME).getSignatures();
    }
}

