/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal;

import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.internal.Support;
import com.silanis.esl.sdk.io.DownloadedFile;
import com.silanis.esl.sdk.io.Streams;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public abstract class Client {
    protected final Support support = new Support();
    protected boolean allowAllSSLCertificates;
    protected boolean useSystemProperties;
    protected ProxyConfiguration proxyConfiguration;

    protected CloseableHttpClient buildHttpClient() throws HttpException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (this.allowAllSSLCertificates) {
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.buildSSLSocketFactory());
        }
        if (this.useSystemProperties) {
            httpClientBuilder.useSystemProperties();
        }
        if (this.proxyConfiguration != null) {
            if (this.proxyConfiguration.hasCredentials()) {
                httpClientBuilder.setDefaultCredentialsProvider(this.buildCredentialsConfiguration(this.proxyConfiguration));
            }
            httpClientBuilder.setDefaultRequestConfig(this.buildProxyConfiguration(this.proxyConfiguration));
            return httpClientBuilder.build();
        }
        return httpClientBuilder.build();
    }

    private RequestConfig buildProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        return RequestConfig.custom().setProxy(new HttpHost(proxyConfiguration.getHost(), proxyConfiguration.getPort(), proxyConfiguration.getScheme())).build();
    }

    private CredentialsProvider buildCredentialsConfiguration(ProxyConfiguration proxyConfiguration) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(proxyConfiguration.getHost(), proxyConfiguration.getPort()), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.getUserName(), proxyConfiguration.getPassword()));
        return credentialsProvider;
    }

    protected SSLConnectionSocketFactory buildSSLSocketFactory() throws HttpException {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
            return new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException e) {
            throw new HttpException("Problem configuring SSL Socket factory", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpException("Problem configuring SSL Socket factory", (Throwable)e);
        }
    }

    protected class JsonHandler
    implements ResponseHandler<String> {
        protected JsonHandler() {
        }

        @Override
        public String extract(InputStream input) {
            try {
                String responseBody = Streams.toString(input);
                Client.this.support.logResponse(responseBody);
                return responseBody;
            }
            catch (UnsupportedEncodingException e) {
                throw new EslException("", e);
            }
        }
    }

    protected class BytesHandler
    implements ResponseHandler<DownloadedFile> {
        protected BytesHandler() {
        }

        @Override
        public DownloadedFile extract(InputStream input) {
            return new DownloadedFile("", Streams.toByteArray(input));
        }
    }

    protected static interface ResponseHandler<T> {
        public T extract(InputStream var1);
    }
}

