/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.apitoken.ApiToken;
import com.silanis.esl.sdk.apitoken.ApiTokenAccessRequest;
import com.silanis.esl.sdk.apitoken.ApiTokenConfig;
import com.silanis.esl.sdk.internal.Client;
import com.silanis.esl.sdk.internal.HttpDeleteWithBody;
import com.silanis.esl.sdk.internal.HttpUtil;
import com.silanis.esl.sdk.internal.MimeTypeUtils;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.io.DownloadedFile;
import com.silanis.esl.sdk.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;

public class RestClient
extends Client {
    public static final String CHARSET_UTF_8 = "UTF-8";
    public static final String ESL_API_VERSION = "11.43";
    public static final String ESL_API_USER_AGENT = "Java SDK v11.43";
    public static final String ESL_API_VERSION_HEADER = "esl-api-version=11.43";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String ESL_CONTENT_TYPE_APPLICATION_JSON = "application/json; esl-api-version=11.43";
    public static final String HEADER_KEY_ACCEPT = "Accept";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String ACCEPT_TYPE_APPLICATION_JSON = "application/json";
    public static final String ACCEPT_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String ACCEPT_TYPE_APPLICATION = "*/*";
    public static final String ESL_ACCEPT_TYPE_APPLICATION_JSON = "application/json; esl-api-version=11.43";
    public static final String ESL_ACCEPT_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream; esl-api-version=11.43";
    public static final String ESL_ACCEPT_TYPE_APPLICATION = "*/*; esl-api-version=11.43";
    private final Client.BytesHandler bytesHandler = new Client.BytesHandler(this);
    private final Client.ResponseHandler<String> jsonHandler = new Client.JsonHandler(this);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String apiKey;
    private final ApiTokenConfig apiTokenConfig;
    private ApiToken apiToken = null;
    private final Map<String, String> additionalHeaders;

    public RestClient(String apiKey) {
        this(apiKey, false);
    }

    public RestClient(String apiKey, boolean allowAllSSLCertificates) {
        this(apiKey, allowAllSSLCertificates, null);
    }

    public RestClient(String apiKey, ProxyConfiguration proxyConfiguration) {
        this(apiKey, false, proxyConfiguration);
    }

    public RestClient(String apiKey, boolean allowAllSSLCertificates, ProxyConfiguration proxyConfiguration) {
        this(apiKey, allowAllSSLCertificates, proxyConfiguration, false, new HashMap<String, String>());
    }

    public RestClient(String apiKey, boolean allowAllSSLCertificates, ProxyConfiguration proxyConfiguration, boolean useSystemProperties, Map<String, String> headers) {
        this.apiKey = apiKey;
        this.apiTokenConfig = null;
        this.allowAllSSLCertificates = allowAllSSLCertificates;
        this.proxyConfiguration = proxyConfiguration;
        this.useSystemProperties = useSystemProperties;
        this.additionalHeaders = headers;
    }

    public RestClient(ApiTokenConfig apiTokenConfig, boolean allowAllSSLCertificates, ProxyConfiguration proxyConfiguration, boolean useSystemProperties, Map<String, String> headers) {
        this.apiKey = null;
        this.apiTokenConfig = apiTokenConfig;
        this.allowAllSSLCertificates = allowAllSSLCertificates;
        this.proxyConfiguration = proxyConfiguration;
        this.useSystemProperties = useSystemProperties;
        this.additionalHeaders = headers;
    }

    public String post(String path, String jsonPayload) throws IOException, RequestException {
        this.support.logRequest("POST", path, jsonPayload);
        HttpPost post = new HttpPost(path);
        post.addHeader(this.buildAcceptHeaderForEslApi());
        if (jsonPayload != null) {
            StringEntity body = new StringEntity(jsonPayload, Charset.forName(CHARSET_UTF_8));
            body.setContentType("application/json; esl-api-version=11.43");
            post.setEntity((HttpEntity)body);
        }
        return this.execute((HttpUriRequest)post, this.jsonHandler);
    }

    public String put(String path, String jsonPayload) throws IOException, RequestException {
        this.support.logRequest("PUT", path, jsonPayload);
        HttpPut put = new HttpPut(path);
        put.addHeader(this.buildAcceptHeaderForEslApi());
        StringEntity body = new StringEntity(jsonPayload, Charset.forName(CHARSET_UTF_8));
        body.setContentType("application/json; esl-api-version=11.43");
        put.setEntity((HttpEntity)body);
        return this.execute((HttpUriRequest)put, this.jsonHandler);
    }

    public void patch(String path, String jsonPayload) throws IOException, RequestException {
        this.support.logRequest("PATCH", path, jsonPayload);
        HttpPatch patch = new HttpPatch(path);
        patch.addHeader(this.buildAcceptHeaderForEslApi());
        StringEntity body = new StringEntity(jsonPayload, Charset.forName(CHARSET_UTF_8));
        body.setContentType("application/json; esl-api-version=11.43");
        patch.setEntity((HttpEntity)body);
        this.execute((HttpUriRequest)patch, this.jsonHandler);
    }

    public String postMultipartFile(String path, Map<String, byte[]> files, String jsonPayload) throws IOException, RequestException {
        this.support.logRequest("POST", path, jsonPayload);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addPart("payload", (ContentBody)this.buildPartForPayload(jsonPayload));
        for (Map.Entry<String, byte[]> file : files.entrySet()) {
            multipartEntityBuilder.addPart("file", this.buildPartForFile(file.getValue(), file.getKey()));
        }
        HttpPost post = new HttpPost(path);
        post.setEntity(multipartEntityBuilder.build());
        return this.execute((HttpUriRequest)post, this.jsonHandler);
    }

    public String postMultipartFile(String path, Map<String, byte[]> files) throws IOException, RequestException {
        this.support.logRequest("POST", path);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        for (Map.Entry<String, byte[]> file : files.entrySet()) {
            multipartEntityBuilder.addPart("file", this.buildPartForFile(file.getValue(), file.getKey()));
        }
        HttpPost post = new HttpPost(path);
        post.setEntity(multipartEntityBuilder.build());
        return this.execute((HttpUriRequest)post, this.jsonHandler);
    }

    public String postMultipartFile(String path, String fileName, byte[] fileBytes, String jsonPayload) throws IOException, RequestException {
        return this.postMultipartFile(path, Collections.singletonMap(fileName, fileBytes), jsonPayload);
    }

    public String postMultipartPackage(String path, Collection<Document> documents, String jsonPayload) throws IOException, RequestException {
        this.support.logRequest("POST", path, jsonPayload);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addPart("payload", (ContentBody)this.buildPartForPayload(jsonPayload));
        for (Document document : documents) {
            if (document.getExternal() != null) continue;
            multipartEntityBuilder.addPart("file", (ContentBody)this.buildPartForFile(document));
        }
        HttpPost post = new HttpPost(path);
        post.setEntity(multipartEntityBuilder.build());
        return this.execute((HttpUriRequest)post, this.jsonHandler);
    }

    private void addAdditionalHeaders(HttpUriRequest request) {
        for (Map.Entry<String, String> entry : this.additionalHeaders.entrySet()) {
            request.setHeader(entry.getKey(), entry.getValue());
        }
    }

    private StringBody buildPartForPayload(String jsonPayload) {
        return new StringBody(jsonPayload, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    private ContentBody buildPartForFile(byte[] content, String fileName) {
        return this.buildPartForFile(content, fileName, fileName);
    }

    private ByteArrayBody buildPartForFile(Document document) {
        return this.buildPartForFile(document.getContent(), document.getFileName(), document.getName());
    }

    private ByteArrayBody buildPartForFile(byte[] content, String fileName, String name) {
        String contentType = MimeTypeUtils.getContentTypeByFileName(fileName);
        return new ByteArrayBody(content, ContentType.create((String)contentType), name);
    }

    protected void addAuthorizationHeader(HttpUriRequest request) {
        if (StringUtils.isNotEmpty((CharSequence)this.apiKey)) {
            request.setHeader("Authorization", "Basic " + this.apiKey);
        } else {
            try {
                request.setHeader("Authorization", "Bearer " + this.getBearerToken());
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
    }

    private String getBearerToken() throws RequestException, IOException {
        if (this.apiTokenConfig != null && (this.apiToken == null || System.currentTimeMillis() > this.apiToken.getExpiresAt() - 60000L)) {
            String url = this.apiTokenConfig.getBaseUrl() + "/apitoken/clientApp/accessToken";
            HttpPost request = this.withUserAgent(new HttpPost(url));
            request.addHeader(HEADER_CONTENT_TYPE, "application/json; esl-api-version=11.43");
            request.setEntity((HttpEntity)new StringEntity(this.getApiTokenPayload()));
            CloseableHttpClient client = this.getHttpClient((HttpUriRequest)request);
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)request);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new EslException("Unable to create access token for " + this.apiTokenConfig);
            }
            this.apiToken = (ApiToken)OBJECT_MAPPER.readValue(httpResponse.getEntity().getContent(), ApiToken.class);
        }
        return this.apiToken.getAccessToken();
    }

    private String getApiTokenPayload() throws JsonProcessingException {
        ApiTokenAccessRequest apiTokenAccessRequest = null;
        if (this.apiTokenConfig != null) {
            apiTokenAccessRequest = ApiTokenAccessRequest.newBuilder().clientId(this.apiTokenConfig.getClientAppId()).secret(this.apiTokenConfig.getClientAppSecret()).type(this.apiTokenConfig.getTokenType()).email(this.apiTokenConfig.getTokenType() == ApiTokenConfig.TokenType.SENDER ? this.apiTokenConfig.getSenderEmail() : null).build();
        }
        return apiTokenAccessRequest != null ? OBJECT_MAPPER.writeValueAsString(apiTokenAccessRequest) : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(HttpUriRequest request, Client.ResponseHandler<T> handler) throws IOException, RequestException {
        this.withUserAgent(request);
        CloseableHttpClient client = this.getHttpClient(request);
        try {
            this.addAdditionalHeaders(request);
            this.addAuthorizationHeader(request);
            this.support.log(request);
            CloseableHttpResponse response = client.execute(request);
            if (response.getStatusLine().getStatusCode() >= 400) {
                String errorDetails = Streams.toString(response.getEntity().getContent());
                throw new RequestException(request.getRequestLine().getMethod(), request.getRequestLine().getUri(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), errorDetails);
            }
            if (response.getStatusLine().getStatusCode() == 204) {
                T errorDetails = null;
                return errorDetails;
            }
            InputStream bodyContent = response.getEntity().getContent();
            if (null != response.getHeaders(HEADER_CONTENT_DISPOSITION) && response.getHeaders(HEADER_CONTENT_DISPOSITION).length > 0) {
                String fileName = this.getFilename(response.getHeaders(HEADER_CONTENT_DISPOSITION)[0].getValue());
                DownloadedFile downloadedFile = (DownloadedFile)handler.extract(bodyContent);
                downloadedFile.setFilename(fileName);
                DownloadedFile downloadedFile2 = downloadedFile;
                return (T)downloadedFile2;
            }
            T t = handler.extract(bodyContent);
            return t;
        }
        finally {
            if (null != client) {
                client.close();
            }
        }
    }

    private CloseableHttpClient getHttpClient(HttpUriRequest request) throws RequestException {
        CloseableHttpClient client;
        try {
            client = this.buildHttpClient();
        }
        catch (HttpException e) {
            throw new RequestException(request.getRequestLine().getMethod(), request.getRequestLine().getUri(), 500, "No SSL Socket Factory", "Could not build request because of SSL socket Factory");
        }
        return client;
    }

    private String getFilename(String disposition) {
        String[] parts;
        String fileNameTitle = "filename*=UTF-8''";
        for (String part : parts = disposition.split(";")) {
            int index = part.indexOf(fileNameTitle);
            if (index <= 0) continue;
            return HttpUtil.percentDecode(part.substring(index + fileNameTitle.length()));
        }
        return "";
    }

    public String get(String path) throws IOException, RequestException {
        return this.get(path, "application/json; esl-api-version=11.43");
    }

    public String get(String path, String acceptType) throws IOException, RequestException {
        this.support.logRequest("GET", path);
        HttpGet get = new HttpGet(path);
        get.addHeader(this.buildAcceptHeader(acceptType));
        return this.execute((HttpUriRequest)get, this.jsonHandler);
    }

    private Header buildAcceptHeaderForEslApi() {
        return this.buildAcceptHeader("application/json; esl-api-version=11.43");
    }

    private Header buildAcceptHeader(String acceptType) {
        return new BasicHeader(HEADER_KEY_ACCEPT, acceptType);
    }

    public DownloadedFile<?> getBytes(String path) throws IOException, RequestException {
        return this.getBytes(path, ESL_ACCEPT_TYPE_APPLICATION);
    }

    public DownloadedFile<?> getBytes(String path, String acceptType) throws IOException, RequestException {
        this.support.logRequest("GET", path);
        HttpGet get = new HttpGet(path);
        get.addHeader(this.buildAcceptHeader(acceptType));
        return this.execute((HttpUriRequest)get, this.bytesHandler);
    }

    public DownloadedFile<?> getBytesAsOctetStream(String path) throws IOException, RequestException {
        return this.getBytes(path, ESL_ACCEPT_TYPE_APPLICATION_OCTET_STREAM);
    }

    public String delete(String path) throws IOException, RequestException {
        this.support.logRequest("DELETE", path);
        HttpDelete delete = new HttpDelete(path);
        delete.addHeader(this.buildAcceptHeaderForEslApi());
        return this.execute((HttpUriRequest)delete, this.jsonHandler);
    }

    public String delete(String path, String jsonPayload) throws IOException, RequestException {
        this.support.logRequest("DELETE", path);
        HttpDeleteWithBody delete = new HttpDeleteWithBody(path);
        delete.addHeader(this.buildAcceptHeaderForEslApi());
        StringEntity body = new StringEntity(jsonPayload, Charset.forName(CHARSET_UTF_8));
        body.setContentType("application/json; esl-api-version=11.43");
        delete.setEntity((HttpEntity)body);
        return this.execute((HttpUriRequest)delete, this.jsonHandler);
    }

    private <T extends HttpRequest> T withUserAgent(T request) {
        request.addHeader("User-Agent", ESL_API_USER_AGENT);
        return request;
    }
}

