/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.BaseMessage;
import com.silanis.esl.api.model.Delivery;
import com.silanis.esl.api.model.Group;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.sdk.AttachmentRequirement;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.Placeholder;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.internal.Asserts;
import com.silanis.esl.sdk.internal.converter.AttachmentRequirementConverter;
import com.silanis.esl.sdk.internal.converter.AuthenticationConverter;
import com.silanis.esl.sdk.internal.converter.KnowledgeBasedAuthenticationConverter;
import com.silanis.esl.sdk.internal.converter.LocaleConverter;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SignerConverter {
    private Signer sdkSigner = null;
    private com.silanis.esl.api.model.Signer apiSigner = null;
    private Role apiRole = null;

    public SignerConverter(Role apiRole) {
        this.apiRole = apiRole;
        if (apiRole != null) {
            this.apiSigner = apiRole.getSigners().get(0);
        }
    }

    public SignerConverter(Signer sdkSigner) {
        this.sdkSigner = sdkSigner;
    }

    public com.silanis.esl.api.model.Signer toAPISigner() {
        if (this.sdkSigner == null) {
            return this.apiSigner;
        }
        com.silanis.esl.api.model.Signer result = new com.silanis.esl.api.model.Signer();
        if (!this.sdkSigner.isGroupSigner()) {
            result.setEmail(this.sdkSigner.getEmail()).setFirstName(this.sdkSigner.getFirstName()).setLastName(this.sdkSigner.getLastName()).setTitle(this.sdkSigner.getTitle()).setCompany(this.sdkSigner.getCompany()).setKnowledgeBasedAuthentication(new KnowledgeBasedAuthenticationConverter(this.sdkSigner.getKnowledgeBasedAuthentication()).toAPIKnowledgeBasedAuthentication()).setDelivery(new Delivery().setEmail(this.sdkSigner.isDeliverSignedDocumentsByEmail()));
        } else {
            result.setGroup(new Group().setId(this.sdkSigner.getGroupId().toString()));
        }
        if (this.sdkSigner.getLanguage() != null) {
            result.setLanguage(LocaleConverter.convertToString(this.sdkSigner.getLanguage()));
        }
        if (this.sdkSigner.getId() != null) {
            result.setId(this.sdkSigner.getId());
        }
        result.setAuth(new AuthenticationConverter(this.sdkSigner.getAuthentication()).toAPIAuthentication());
        return result;
    }

    private Signer newRegularSignerFromAPIRole() {
        Object localLanguage;
        Map<String, Object> apiRoleData;
        SignerBuilder signerBuilder;
        if (this.apiSigner.getGroup() == null) {
            signerBuilder = SignerBuilder.newSignerWithEmail(this.apiSigner.getEmail()).withFirstName(this.apiSigner.getFirstName()).withLastName(this.apiSigner.getLastName()).withCompany(this.apiSigner.getCompany()).withLanguage(LocaleConverter.convertToLocale(this.apiSigner.getLanguage())).withTitle(this.apiSigner.getTitle()).challengedWithKnowledgeBasedAuthentication(new KnowledgeBasedAuthenticationConverter(this.apiSigner.getKnowledgeBasedAuthentication()).toSDKKnowledgeBasedAuthentication());
            if (this.apiSigner.getDelivery() != null && this.apiSigner.getDelivery().getEmail().booleanValue()) {
                signerBuilder.deliverSignedDocumentsByEmail();
            }
        } else {
            signerBuilder = SignerBuilder.newSignerFromGroup(new GroupId(this.apiSigner.getGroup().getId()));
        }
        signerBuilder.withCustomId(this.apiSigner.getId()).withRoleId(this.apiRole.getId());
        if (this.apiRole.getIndex() != null) {
            signerBuilder.signingOrder(this.apiRole.getIndex());
        }
        if (this.apiRole.evalReassign()) {
            signerBuilder.canChangeSigner();
        }
        if (this.apiRole.getEmailMessage() != null) {
            signerBuilder.withEmailMessage(this.apiRole.getEmailMessage().getContent());
        }
        signerBuilder.withAuthentication(new AuthenticationConverter(this.apiSigner.getAuth()).toSDKAuthentication());
        for (com.silanis.esl.api.model.AttachmentRequirement attachmentRequirement : this.apiRole.getAttachmentRequirements()) {
            signerBuilder.withAttachmentRequirement(new AttachmentRequirementConverter(attachmentRequirement).toSDKAttachmentRequirement());
        }
        Signer signer = signerBuilder.build();
        if (this.apiSigner.getSignerType() != null) {
            signer.setSignerType(this.apiSigner.getSignerType());
        }
        if (this.apiRole.evalLocked()) {
            signer.setLocked(true);
        }
        if ((apiRoleData = this.apiRole.getData()) != null && apiRoleData.containsKey("localLanguage") && (localLanguage = apiRoleData.get("localLanguage")) != null) {
            signer.setLocalLanguage(localLanguage.toString());
        }
        return signer;
    }

    private Signer newSignerPlaceholderFromAPIRole() {
        Object localLanguage;
        Map<String, Object> apiRoleData;
        Asserts.notNullOrEmpty(this.apiRole.getId(), "role.id");
        SignerBuilder signerBuilder = SignerBuilder.newSignerPlaceholder(new Placeholder(this.apiRole.getId())).signingOrder(this.apiRole.getIndex());
        if (this.apiRole.evalReassign()) {
            signerBuilder.canChangeSigner();
        }
        if (this.apiRole.getEmailMessage() != null) {
            signerBuilder.withEmailMessage(this.apiRole.getEmailMessage().getContent());
        }
        if (this.apiRole.getIndex() != null) {
            signerBuilder.signingOrder(this.apiRole.getIndex());
        }
        Signer signer = signerBuilder.build();
        if (this.apiRole.getLocked().booleanValue()) {
            signer.setLocked(true);
        }
        if ((apiRoleData = this.apiRole.getData()) != null && apiRoleData.containsKey("localLanguage") && (localLanguage = apiRoleData.get("localLanguage")) != null) {
            signer.setLocalLanguage(localLanguage.toString());
        }
        return signer;
    }

    public Signer toSDKSigner() {
        if (this.apiRole == null) {
            return this.sdkSigner;
        }
        if (this.apiRole.getSigners() == null || this.apiRole.getSigners().isEmpty()) {
            return this.newSignerPlaceholderFromAPIRole();
        }
        return this.newRegularSignerFromAPIRole();
    }

    public Role toAPIRole(String roleIdName) {
        Role role = new Role();
        if (!this.sdkSigner.isPlaceholderSigner()) {
            role.addSigner(new SignerConverter(this.sdkSigner).toAPISigner());
        }
        role.setIndex(this.sdkSigner.getSigningOrder());
        role.setReassign(this.sdkSigner.canChangeSigner());
        if (StringUtils.isEmpty((CharSequence)this.sdkSigner.getId())) {
            role.setId(roleIdName);
            role.setName(roleIdName);
        } else {
            role.setId(this.sdkSigner.getId());
            role.setName(this.sdkSigner.getId());
        }
        if (this.sdkSigner.getMessage() != null && !this.sdkSigner.getMessage().isEmpty()) {
            BaseMessage message = new BaseMessage();
            message.setContent(this.sdkSigner.getMessage());
            role.setEmailMessage(message);
        }
        role.setLocked(this.sdkSigner.isLocked());
        for (AttachmentRequirement attachmentRequirement : this.sdkSigner.getAttachmentRequirements()) {
            role.addAttachmentRequirement(new AttachmentRequirementConverter(attachmentRequirement).toAPIAttachmentRequirement());
        }
        String localLanguage = this.sdkSigner.getLocalLanguage();
        if (localLanguage != null) {
            role.putData("localLanguage", localLanguage);
        }
        return role;
    }

    public Role toAPIRole(String id, String name) {
        Role role = new Role();
        if (!this.sdkSigner.isPlaceholderSigner()) {
            role.addSigner(new SignerConverter(this.sdkSigner).toAPISigner());
        }
        role.setIndex(this.sdkSigner.getSigningOrder());
        role.setReassign(this.sdkSigner.canChangeSigner());
        if (StringUtils.isEmpty((CharSequence)this.sdkSigner.getId())) {
            role.setId(id);
        } else {
            role.setId(this.sdkSigner.getId());
        }
        if (StringUtils.isEmpty((CharSequence)this.sdkSigner.getPlaceholderName())) {
            role.setName(name);
        } else {
            role.setName(this.sdkSigner.getPlaceholderName());
        }
        if (this.sdkSigner.getMessage() != null && !this.sdkSigner.getMessage().isEmpty()) {
            BaseMessage message = new BaseMessage();
            message.setContent(this.sdkSigner.getMessage());
            role.setEmailMessage(message);
        }
        role.setLocked(this.sdkSigner.isLocked());
        for (AttachmentRequirement attachmentRequirement : this.sdkSigner.getAttachmentRequirements()) {
            role.addAttachmentRequirement(new AttachmentRequirementConverter(attachmentRequirement).toAPIAttachmentRequirement());
        }
        String localLanguage = this.sdkSigner.getLocalLanguage();
        if (localLanguage != null) {
            role.putData("localLanguage", localLanguage);
        }
        return role;
    }
}

