/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.silanis.esl.api.model.IdvWorkflowConfiguration;
import com.silanis.esl.sdk.Handover;
import com.silanis.esl.sdk.IdvWorkflowConfig;
import com.silanis.esl.sdk.internal.converter.HandoverConverter;
import com.silanis.esl.sdk.internal.converter.IdvWorkflowConfigConverter;
import com.silanis.esl.sdk.internal.converter.LocaleConverter;
import com.silanis.esl.sdk.service.apiclient.AccountConfigClient;
import java.util.List;
import java.util.Locale;

public class AccountConfigService {
    private AccountConfigClient apiClient;

    public AccountConfigService(AccountConfigClient apiClient) {
        this.apiClient = apiClient;
    }

    public Handover getHandoverUrl(Locale language) {
        com.silanis.esl.api.model.Handover handover = this.apiClient.getHandoverUrl(LocaleConverter.convertToString(language));
        return new HandoverConverter(handover).toSDKHandover(language);
    }

    public Handover createHandoverUrl(Handover sdkHandover) {
        com.silanis.esl.api.model.Handover apiHandover = new HandoverConverter(sdkHandover).toAPIHandover();
        apiHandover = this.apiClient.createHandoverUrl(LocaleConverter.convertToString(sdkHandover.getLanguage()), apiHandover);
        return new HandoverConverter(apiHandover).toSDKHandover(sdkHandover.getLanguage());
    }

    public Handover updateHandoverUrl(Handover handover) {
        com.silanis.esl.api.model.Handover apiHandover = new HandoverConverter(handover).toAPIHandover();
        apiHandover = this.apiClient.updateHandoverUrl(LocaleConverter.convertToString(handover.getLanguage()), apiHandover);
        return new HandoverConverter(apiHandover).toSDKHandover(handover.getLanguage());
    }

    public void deleteHandoverUrl(Locale language) {
        this.apiClient.deleteHandoverUrl(LocaleConverter.convertToString(language));
    }

    public List<String> getDeclineReasons(Locale language) {
        return this.apiClient.getDeclineReasons(LocaleConverter.convertToString(language));
    }

    public List<String> createDeclineReasons(Locale language, List<String> declineReasons) {
        return this.apiClient.createDeclineReasons(LocaleConverter.convertToString(language), declineReasons);
    }

    public List<String> updateDeclineReasons(Locale language, List<String> declineReasons) {
        return this.apiClient.updateDeclineReasons(LocaleConverter.convertToString(language), declineReasons);
    }

    public void deleteDeclineReasons(Locale language) {
        this.apiClient.deleteDeclineReasons(LocaleConverter.convertToString(language));
    }

    public List<IdvWorkflowConfig> getIdvWorkflowConfigs() {
        List<IdvWorkflowConfiguration> idvWorkflowConfigurations = this.apiClient.getIdvWorkflowConfigs();
        return Lists.newArrayList((Iterable)Iterables.transform(idvWorkflowConfigurations, (Function)new Function<IdvWorkflowConfiguration, IdvWorkflowConfig>(){

            public IdvWorkflowConfig apply(IdvWorkflowConfiguration input) {
                return new IdvWorkflowConfigConverter(input).toSDKIdvWorkflowConfig();
            }
        }));
    }

    public List<IdvWorkflowConfig> createIdvWorkflowConfigs(List<IdvWorkflowConfig> idvWorkflowConfigs) {
        List<Object> idvWorkflowConfigurations = Lists.newArrayList((Iterable)Iterables.transform(idvWorkflowConfigs, (Function)new Function<IdvWorkflowConfig, IdvWorkflowConfiguration>(){

            public IdvWorkflowConfiguration apply(IdvWorkflowConfig input) {
                return new IdvWorkflowConfigConverter(input).toAPIIdvWorkflowConfiguration();
            }
        }));
        idvWorkflowConfigurations = this.apiClient.createIdvWorkflowConfigs(idvWorkflowConfigurations);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)idvWorkflowConfigurations, (Function)new Function<IdvWorkflowConfiguration, IdvWorkflowConfig>(){

            public IdvWorkflowConfig apply(IdvWorkflowConfiguration input) {
                return new IdvWorkflowConfigConverter(input).toSDKIdvWorkflowConfig();
            }
        }));
    }

    public List<IdvWorkflowConfig> updateIdvWorkflowConfigs(List<IdvWorkflowConfig> idvWorkflowConfigs) {
        List<Object> idvWorkflowConfigurations = Lists.newArrayList((Iterable)Iterables.transform(idvWorkflowConfigs, (Function)new Function<IdvWorkflowConfig, IdvWorkflowConfiguration>(){

            public IdvWorkflowConfiguration apply(IdvWorkflowConfig input) {
                return new IdvWorkflowConfigConverter(input).toAPIIdvWorkflowConfiguration();
            }
        }));
        idvWorkflowConfigurations = this.apiClient.updateIdvWorkflowConfigs(idvWorkflowConfigurations);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)idvWorkflowConfigurations, (Function)new Function<IdvWorkflowConfiguration, IdvWorkflowConfig>(){

            public IdvWorkflowConfig apply(IdvWorkflowConfiguration input) {
                return new IdvWorkflowConfigConverter(input).toSDKIdvWorkflowConfig();
            }
        }));
    }

    public void deleteIdvWorkflowConfigs() {
        this.apiClient.deleteIdvWorkflowConfigs();
    }
}

