/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.Result;
import com.silanis.esl.api.model.VerificationType;
import com.silanis.esl.sdk.AccessibleAccountResponse;
import com.silanis.esl.sdk.Account;
import com.silanis.esl.sdk.AccountMember;
import com.silanis.esl.sdk.AccountRole;
import com.silanis.esl.sdk.DelegationUser;
import com.silanis.esl.sdk.Direction;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.Sender;
import com.silanis.esl.sdk.SenderImageSignature;
import com.silanis.esl.sdk.SenderInfo;
import com.silanis.esl.sdk.SubAccount;
import com.silanis.esl.sdk.SubAccountApiKey;
import com.silanis.esl.sdk.internal.converter.AccessibleAccountResponseConverter;
import com.silanis.esl.sdk.internal.converter.AccountConverter;
import com.silanis.esl.sdk.internal.converter.AccountMemberConverter;
import com.silanis.esl.sdk.internal.converter.AccountRoleConverter;
import com.silanis.esl.sdk.internal.converter.DelegationUserConverter;
import com.silanis.esl.sdk.internal.converter.SenderConverter;
import com.silanis.esl.sdk.internal.converter.SenderImageSignatureConverter;
import com.silanis.esl.sdk.internal.converter.SubAccountApiKeyConverter;
import com.silanis.esl.sdk.internal.converter.SubAccountConverter;
import com.silanis.esl.sdk.service.apiclient.AccountApiClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountService {
    private final AccountApiClient apiClient;

    public AccountService(AccountApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Sender inviteUser(AccountMember accountMember) {
        com.silanis.esl.api.model.Sender sender = new AccountMemberConverter(accountMember).toAPISender();
        sender = this.apiClient.inviteUser(sender);
        return new SenderConverter(sender).toSDKSender();
    }

    public void sendInvite(String senderId) {
        this.apiClient.sendInvite(senderId);
    }

    public Map<String, Sender> getSenders(Direction direction, PageRequest request) {
        Result<com.silanis.esl.api.model.Sender> apiResponse = this.apiClient.getSenders(direction, request);
        HashMap<String, Sender> result = new HashMap<String, Sender>();
        for (com.silanis.esl.api.model.Sender sender : apiResponse.getResults()) {
            result.put(sender.getEmail(), new SenderConverter(sender).toSDKSender());
        }
        return result;
    }

    public Sender getSender(String senderId) {
        com.silanis.esl.api.model.Sender apiResponse = this.apiClient.getSender(senderId);
        return new SenderConverter(apiResponse).toSDKSender();
    }

    public void deleteSender(String senderId) {
        this.apiClient.deleteSender(senderId);
    }

    public void updateSender(SenderInfo sender, String senderId) {
        com.silanis.esl.api.model.Sender apiSender = new SenderConverter(sender).toAPISender();
        apiSender.setId(senderId);
        this.apiClient.updateSender(apiSender, senderId);
    }

    public void updateSenderImageSignature(String fileName, byte[] fileContent, String senderId) {
        this.apiClient.updateSenderImageSignature(fileName, fileContent, senderId);
    }

    public SenderImageSignature getSenderImageSignature(String senderId) {
        com.silanis.esl.api.model.SenderImageSignature apiResponse = this.apiClient.getSenderImageSignature(senderId);
        return new SenderImageSignatureConverter(apiResponse).toSDKSenderImageSignature();
    }

    public void deleteSenderImageSignature(String senderId) {
        this.apiClient.deleteSenderImageSignature(senderId);
    }

    public Map<String, Sender> getContacts() {
        List<com.silanis.esl.api.model.Sender> contacts = this.apiClient.getContacts();
        HashMap<String, Sender> result = new HashMap<String, Sender>();
        for (com.silanis.esl.api.model.Sender apiSender : contacts) {
            result.put(apiSender.getEmail(), new SenderConverter(apiSender).toSDKSender());
        }
        return result;
    }

    public List<DelegationUser> getDelegates(String senderId) {
        ArrayList<DelegationUser> result = new ArrayList<DelegationUser>();
        List<com.silanis.esl.api.model.DelegationUser> apiDelegationUsers = this.apiClient.getDelegates(senderId);
        for (com.silanis.esl.api.model.DelegationUser delegationUser : apiDelegationUsers) {
            result.add(new DelegationUserConverter(delegationUser).toSDKDelegationUser());
        }
        return result;
    }

    public void updateDelegates(String senderId, List<String> delegateIds) {
        this.apiClient.updateDelegates(senderId, delegateIds);
    }

    public void updateDelegationWithDelegationUsers(String senderId, List<DelegationUser> delegates) {
        ArrayList<com.silanis.esl.api.model.DelegationUser> apiDelegates = new ArrayList<com.silanis.esl.api.model.DelegationUser>();
        for (DelegationUser delegate : delegates) {
            apiDelegates.add(new DelegationUserConverter(delegate).toAPIDelegationUser());
        }
        this.apiClient.updateDelegates(senderId, apiDelegates);
    }

    public void addDelegate(String senderId, DelegationUser delegationUser) {
        com.silanis.esl.api.model.DelegationUser apiDelegationUser = new DelegationUserConverter(delegationUser).toAPIDelegationUser();
        this.apiClient.addDelegate(senderId, apiDelegationUser);
    }

    public void removeDelegate(String senderId, String delegateId) {
        this.apiClient.removeDelegate(senderId, delegateId);
    }

    public void clearDelegates(String senderId) {
        this.apiClient.clearDelegates(senderId);
    }

    public List<VerificationType> getVerificationTypes() {
        return this.apiClient.getVerificationTypes();
    }

    public List<AccountRole> getAccountRoles() {
        ArrayList<AccountRole> roles = new ArrayList<AccountRole>();
        for (com.silanis.esl.api.model.AccountRole accountRole : this.apiClient.getAccountRoles()) {
            roles.add(new AccountRoleConverter(accountRole).toSDKAccountRole());
        }
        return roles;
    }

    public void addAccountRole(AccountRole accountRole) {
        this.apiClient.addAccountRole(new AccountRoleConverter(accountRole).toAPIAccountRole());
    }

    public void updateAccountRole(String accountRoleId, AccountRole accountRole) {
        this.apiClient.updateAccountRole(accountRoleId, new AccountRoleConverter(accountRole).toAPIAccountRole());
    }

    public AccountRole getAccountRole(String accountRoleId) {
        return new AccountRoleConverter(this.apiClient.getAccountRole(accountRoleId)).toSDKAccountRole();
    }

    public List<Account> getSubAccounts() {
        List<com.silanis.esl.api.model.Account> apiAccounts = this.apiClient.getSubAccounts();
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (com.silanis.esl.api.model.Account account : apiAccounts) {
            accounts.add(new AccountConverter(account).toSDKAccount());
        }
        return accounts;
    }

    public List<SubAccountApiKey> getSubAccountApiKeys() {
        List<com.silanis.esl.api.model.SubAccountApiKey> subAccountApiKeyResponses = this.apiClient.getSubAccountApiKey();
        ArrayList<SubAccountApiKey> subAccountApiKeyList = new ArrayList<SubAccountApiKey>();
        for (com.silanis.esl.api.model.SubAccountApiKey subAccountApiKey : subAccountApiKeyResponses) {
            subAccountApiKeyList.add(new SubAccountApiKeyConverter(subAccountApiKey).toSDKSubAccountApiKey());
        }
        return subAccountApiKeyList;
    }

    public List<AccessibleAccountResponse> getAccessibleAccounts() {
        List<com.silanis.esl.api.model.AccessibleAccountResponse> apiAccessibleAccounts = this.apiClient.getAccessibleAccounts();
        ArrayList<AccessibleAccountResponse> accountResponses = new ArrayList<AccessibleAccountResponse>();
        for (com.silanis.esl.api.model.AccessibleAccountResponse accountResponse : apiAccessibleAccounts) {
            accountResponses.add(new AccessibleAccountResponseConverter(accountResponse).toSDKAccessibleAccountResponse());
        }
        return accountResponses;
    }

    public Account createSubAccount(SubAccount subAccount) {
        com.silanis.esl.api.model.SubAccount apiSubAccount = new SubAccountConverter(subAccount).toAPISubAccount();
        com.silanis.esl.api.model.Account apiAccount = this.apiClient.createSubAccount(apiSubAccount);
        return new AccountConverter(apiAccount).toSDKAccount();
    }

    public void updateSubAccount(SubAccount subAccount, String accountId) {
        com.silanis.esl.api.model.SubAccount apiSubAccount = new SubAccountConverter(subAccount).toAPISubAccount();
        this.apiClient.updateSubAccount(apiSubAccount, accountId);
    }

    public void deleteAccountRole(String accountRoleId) {
        this.apiClient.deleteAccountRole(accountRoleId);
    }

    public List<String> getAccountRoleUsers(String accountRoleId) {
        return this.apiClient.getAccountRoleUsers(accountRoleId);
    }
}

