/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.RequirementStatus;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.SignerRestClient;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.DocumentPackageConverter;
import com.silanis.esl.sdk.io.DownloadedFile;
import com.silanis.esl.sdk.service.PackageService;
import com.silanis.esl.sdk.service.apiclient.AttachmentRequirementApiClient;
import java.io.IOException;
import java.util.Map;

public class AttachmentRequirementService {
    private UrlTemplate template;
    private RestClient client;
    private PackageService packageService;

    public AttachmentRequirementService(AttachmentRequirementApiClient apiClient, RestClient restClient, String baseUrl) {
        this.packageService = new PackageService(restClient, baseUrl);
        this.client = restClient;
        this.template = new UrlTemplate(baseUrl);
    }

    public void acceptAttachment(PackageId packageId, Signer signer, String attachmentName) {
        signer.getAttachmentRequirement(attachmentName).setSenderComment("");
        signer.getAttachmentRequirement(attachmentName).setStatus(RequirementStatus.COMPLETE);
        this.packageService.updateSigner(packageId, signer);
    }

    public void rejectAttachment(PackageId packageId, Signer signer, String attachmentName, String senderComment) {
        signer.getAttachmentRequirement(attachmentName).setSenderComment(senderComment);
        signer.getAttachmentRequirement(attachmentName).setStatus(RequirementStatus.REJECTED);
        this.packageService.updateSigner(packageId, signer);
    }

    @Deprecated
    public byte[] downloadAttachment(PackageId packageId, String attachmentId) {
        return this.downloadAttachmentFile(packageId, attachmentId).getContents();
    }

    public DownloadedFile downloadAttachmentFile(PackageId packageId, String attachmentId) {
        String path = this.template.urlFor("/packages/{packageId}/attachment/{attachmentId}").replace("{packageId}", packageId.getId()).replace("{attachmentId}", attachmentId).build();
        try {
            return this.client.getBytes(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the pdf attachment.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the pdf attachment. Exception: " + e.getMessage());
        }
    }

    public DownloadedFile downloadAttachmentFile(PackageId packageId, String attachmentId, Integer fileId) {
        String path = this.template.urlFor("/packages/{packageId}/attachment/{attachmentId}/file/{fileId}").replace("{packageId}", packageId.getId()).replace("{attachmentId}", attachmentId).replace("{fileId}", String.valueOf(fileId)).build();
        try {
            return this.client.getBytes(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the attachment file.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the attachment file. Exception: " + e.getMessage());
        }
    }

    @Deprecated
    public byte[] downloadAllAttachmentsForPackage(PackageId packageId) {
        return this.downloadAllAttachmentFilesForPackage(packageId).getContents();
    }

    public DownloadedFile downloadAllAttachmentFilesForPackage(PackageId packageId) {
        String path = this.template.urlFor("/packages/{packageId}/attachment/zip").replace("{packageId}", packageId.getId()).build();
        try {
            return this.client.getBytes(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download all attachments.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download all attachments. Exception: " + e.getMessage());
        }
    }

    @Deprecated
    public byte[] downloadAllAttachmentsForSignerInPackage(DocumentPackage sdkPackage, Signer signer) {
        return this.downloadAllAttachmentFilesForSignerInPackage(sdkPackage, signer).getContents();
    }

    public DownloadedFile downloadAllAttachmentFilesForSignerInPackage(DocumentPackage sdkPackage, Signer signer) {
        Package apiPackage = new DocumentPackageConverter(sdkPackage).toAPIPackage();
        String roleId = "";
        for (Role role : apiPackage.getRoles()) {
            for (com.silanis.esl.api.model.Signer apiSigner : role.getSigners()) {
                if (!signer.getEmail().equals(apiSigner.getEmail())) continue;
                roleId = role.getId();
            }
        }
        return this.downloadAllAttachmentsForSignerInPackage(sdkPackage.getId(), roleId);
    }

    private DownloadedFile downloadAllAttachmentsForSignerInPackage(PackageId packageId, String roleId) {
        String path = this.template.urlFor("/packages/{packageId}/attachment/zip/{roleId}").replace("{packageId}", packageId.getId()).replace("{roleId}", roleId).build();
        try {
            return this.client.getBytes(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download all attachments for the signer in the package.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download all attachments for the signer in the package. Exception: " + e.getMessage());
        }
    }

    public void uploadAttachment(PackageId packageId, String attachmentId, Map<String, byte[]> files, String signerSessionId) {
        SignerRestClient signerClient = new SignerRestClient(signerSessionId, true);
        String path = this.template.urlFor("/packages/{packageId}/attachment/{attachmentId}").replace("{packageId}", packageId.getId()).replace("{attachmentId}", attachmentId).build();
        try {
            signerClient.postMultipartFile(path, files, "");
        }
        catch (RequestException e) {
            throw new EslServerException("Could not upload attachment for signer.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not upload attachment for signer. Exception: " + e.getMessage());
        }
    }

    public void deleteAttachmentFile(PackageId packageId, String attachmentId, Integer fileId, String signerSessionId) {
        SignerRestClient signerClient = new SignerRestClient(signerSessionId, true);
        String path = this.template.urlFor("/packages/{packageId}/attachment/{attachmentId}/file/{fileId}").replace("{packageId}", packageId.getId()).replace("{attachmentId}", attachmentId).replace("{fileId}", String.valueOf(fileId)).build();
        try {
            signerClient.delete(path);
        }
        catch (IOException e) {
            throw new EslException("Could not upload attachment for signer. Exception: " + e.getMessage());
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete attachment file for signer", e);
        }
    }
}

