/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service.apiclient;

import com.silanis.esl.api.model.Handover;
import com.silanis.esl.api.model.IdvWorkflowConfiguration;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import java.util.List;

public class AccountConfigClient {
    private UrlTemplate template;
    private RestClient restClient;

    public AccountConfigClient(RestClient restClient, String apiUrl) {
        this.restClient = restClient;
        this.template = new UrlTemplate(apiUrl);
    }

    public Handover getHandoverUrl(String language) {
        String path = this.template.urlFor("/accountConfig/handoverUrl/{language}").replace("{language}", language).build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJson(stringResponse, Handover.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get handover url.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get handover url.", e);
        }
    }

    public Handover createHandoverUrl(String language, Handover handover) {
        String path = this.template.urlFor("/accountConfig/handoverUrl/{language}").replace("{language}", language).build();
        try {
            String json = Serialization.toJson(handover);
            String stringResponse = this.restClient.post(path, json);
            return Serialization.fromJson(stringResponse, Handover.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create handover url.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create handover url.", e);
        }
    }

    public Handover updateHandoverUrl(String language, Handover handover) {
        String path = this.template.urlFor("/accountConfig/handoverUrl/{language}").replace("{language}", language).build();
        try {
            String json = Serialization.toJson(handover);
            String stringResponse = this.restClient.put(path, json);
            return Serialization.fromJson(stringResponse, Handover.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update handover url.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update handover url.", e);
        }
    }

    public void deleteHandoverUrl(String language) {
        String path = this.template.urlFor("/accountConfig/handoverUrl/{language}").replace("{language}", language).build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete handover url.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete handover url.", e);
        }
    }

    public List<String> createDeclineReasons(String language, List<String> declineReasons) {
        String path = this.template.urlFor("/accountConfig/declineReasons/{language}").replace("{language}", language).build();
        String json = Serialization.toJson(declineReasons);
        try {
            String stringResponse = this.restClient.post(path, json);
            return Serialization.fromJsonToList(stringResponse, String.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create decline reasons.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create decline reasons.", e);
        }
    }

    public List<String> updateDeclineReasons(String language, List<String> declineReasons) {
        String path = this.template.urlFor("/accountConfig/declineReasons/{language}").replace("{language}", language).build();
        String json = Serialization.toJson(declineReasons);
        try {
            String stringResponse = this.restClient.put(path, json);
            return Serialization.fromJsonToList(stringResponse, String.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update decline reasons.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update decline reasons.", e);
        }
    }

    public List<String> getDeclineReasons(String language) {
        String path = this.template.urlFor("/accountConfig/declineReasons/{language}").replace("{language}", language).build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJsonToList(stringResponse, String.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get decline reasons.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get decline reasons.", e);
        }
    }

    public void deleteDeclineReasons(String language) {
        String path = this.template.urlFor("/accountConfig/declineReasons/{language}").replace("{language}", language).build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete decline reasons.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete decline reasons.", e);
        }
    }

    public List<IdvWorkflowConfiguration> getIdvWorkflowConfigs() {
        String path = this.template.urlFor("/accountConfig/idvWorkflowConfigs").build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJsonToList(stringResponse, IdvWorkflowConfiguration.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get IdvWorkflow Configs.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get IdvWorkflow Configs.", e);
        }
    }

    public List<IdvWorkflowConfiguration> createIdvWorkflowConfigs(List<IdvWorkflowConfiguration> idvWorkflowConfigurations) {
        String path = this.template.urlFor("/accountConfig/idvWorkflowConfigs").build();
        try {
            String json = Serialization.toJson(idvWorkflowConfigurations);
            String stringResponse = this.restClient.post(path, json);
            return Serialization.fromJsonToList(stringResponse, IdvWorkflowConfiguration.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create IdvWorkflow Configs.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create IdvWorkflow Configs.", e);
        }
    }

    public List<IdvWorkflowConfiguration> updateIdvWorkflowConfigs(List<IdvWorkflowConfiguration> idvWorkflowConfigurations) {
        String path = this.template.urlFor("/accountConfig/idvWorkflowConfigs").build();
        try {
            String json = Serialization.toJson(idvWorkflowConfigurations);
            String stringResponse = this.restClient.put(path, json);
            return Serialization.fromJsonToList(stringResponse, IdvWorkflowConfiguration.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update IdvWorkflow Configs.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update IdvWorkflow Configs.", e);
        }
    }

    public void deleteIdvWorkflowConfigs() {
        String path = this.template.urlFor("/accountConfig/idvWorkflowConfigs").build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete IdvWorkflow Configs.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete IdvWorkflow Configs.", e);
        }
    }
}

