/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentPackageAttributes;
import com.silanis.esl.sdk.DocumentPackageSettings;
import com.silanis.esl.sdk.FieldCondition;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.PackageStatus;
import com.silanis.esl.sdk.SenderInfo;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.Visibility;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageAttributesBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageSettingsBuilder;
import com.silanis.esl.sdk.builder.SenderInfoBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class PackageBuilder {
    private final String packageName;
    private final List<Signer> signers = new ArrayList<Signer>();
    private final List<Signer> placeholders = new ArrayList<Signer>();
    private List<Document> documents = new ArrayList<Document>();
    private boolean autocomplete = true;
    private String description = null;
    private Date expiryDate;
    private String packageMessage = null;
    private Boolean notarized;
    private Boolean trashed;
    private PackageId id;
    private PackageStatus status;
    private DocumentPackageSettings settings;
    private Locale language;
    private SenderInfo senderInfo = null;
    private DocumentPackageAttributes attributes;
    private Visibility visibility;
    private String timezoneId;
    private final List<FieldCondition> conditions = new ArrayList<FieldCondition>();
    private static final String ORIGIN_KEY = "origin";

    public PackageBuilder(String packageName) {
        this.packageName = packageName;
    }

    public static PackageBuilder newPackageNamed(String name) {
        return new PackageBuilder(name);
    }

    @Deprecated
    public PackageBuilder withID(PackageId id) {
        this.id = id;
        return this;
    }

    public PackageBuilder withSigner(SignerBuilder builder) {
        return this.withSigner(builder.build());
    }

    public PackageBuilder withSigner(Signer signer) {
        if (signer.isPlaceholderSigner()) {
            this.placeholders.add(signer);
        } else {
            this.signers.add(signer);
        }
        return this;
    }

    public PackageBuilder withDocument(DocumentBuilder builder) {
        return this.withDocument(builder.build());
    }

    public PackageBuilder withDocument(Document document) {
        this.addDocument(document);
        return this;
    }

    public PackageBuilder withNotarized(Boolean notarized) {
        this.notarized = notarized;
        return this;
    }

    public PackageBuilder withTrashed(Boolean trashed) {
        this.trashed = trashed;
        return this;
    }

    public PackageBuilder withVisibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public PackageBuilder withTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
        return this;
    }

    public DocumentPackage build() {
        DocumentPackage documentPackage = new DocumentPackage(this.packageName, this.signers, this.placeholders, this.documents, this.autocomplete);
        documentPackage.setExpiryDate(this.expiryDate);
        documentPackage.setId(this.id);
        documentPackage.setStatus(this.status);
        documentPackage.setSenderInfo(this.senderInfo);
        documentPackage.setAttributes(this.attributes);
        if (this.language != null) {
            documentPackage.setLanguage(this.language);
        }
        if (this.settings != null) {
            documentPackage.setSettings(this.settings);
        }
        if (this.description != null) {
            documentPackage.setDescription(this.description);
        }
        if (this.packageMessage != null) {
            documentPackage.setPackageMessage(this.packageMessage);
        }
        if (this.notarized != null) {
            documentPackage.setNotarized(this.notarized);
        }
        if (this.trashed != null) {
            documentPackage.setTrashed(this.trashed);
        }
        if (this.visibility != null) {
            documentPackage.setVisibility(this.visibility);
        }
        if (this.timezoneId != null) {
            documentPackage.setTimezoneId(this.timezoneId);
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            documentPackage.setConditions(this.conditions);
        }
        return documentPackage;
    }

    private void addDocument(Document document) {
        this.documents.add(document);
    }

    public PackageBuilder autocomplete(boolean autocomplete) {
        this.autocomplete = autocomplete;
        return this;
    }

    public PackageBuilder withStatus(PackageStatus status) {
        this.status = status;
        return this;
    }

    public PackageBuilder describedAs(String description) {
        this.description = description;
        return this;
    }

    public PackageBuilder expiresAt(Date expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    public PackageBuilder withEmailMessage(String packageMessage) {
        this.packageMessage = packageMessage;
        return this;
    }

    public PackageBuilder withSettings(DocumentPackageSettingsBuilder builder) {
        return this.withSettings(builder.build());
    }

    public PackageBuilder withSettings(DocumentPackageSettings settings) {
        this.settings = settings;
        return this;
    }

    public PackageBuilder withLanguage(Locale language) {
        this.language = language;
        return this;
    }

    public PackageBuilder withSenderInfo(SenderInfoBuilder senderInfoBuilder) {
        return this.withSenderInfo(senderInfoBuilder.build());
    }

    public PackageBuilder withSenderInfo(SenderInfo senderInfo) {
        this.senderInfo = senderInfo;
        return this;
    }

    public PackageBuilder withAttributes(DocumentPackageAttributes attributes) {
        if (null == this.attributes) {
            this.attributes = new DocumentPackageAttributes();
        }
        this.attributes.append(attributes);
        return this;
    }

    public PackageBuilder withAttributes(DocumentPackageAttributesBuilder builder) {
        return this.withAttributes(builder.build());
    }

    public PackageBuilder withOrigin(String origin) {
        if (null == this.attributes) {
            this.attributes = new DocumentPackageAttributes();
        }
        this.attributes.append(ORIGIN_KEY, origin);
        return this;
    }

    public PackageBuilder withCondition(FieldCondition condition) {
        this.conditions.add(condition);
        return this;
    }
}

