/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.Placeholder;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.SignatureId;
import com.silanis.esl.sdk.SignatureStyle;
import com.silanis.esl.sdk.TextAnchor;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.TextAnchorBuilder;
import java.util.ArrayList;
import java.util.Collection;

public final class SignatureBuilder {
    public static final double DEFAULT_WIDTH = 200.0;
    public static final double DEFAULT_HEIGHT = 50.0;
    public static final SignatureStyle DEFAULT_STYLE = SignatureStyle.FULL_NAME;
    private SignatureId id;
    private GroupId groupId;
    private Placeholder roleId;
    private String name;
    private String signerEmail;
    private int pageNumber;
    private double x;
    private double y;
    private double width = 200.0;
    private double height = 50.0;
    private Integer fontSize = null;
    private SignatureStyle style = DEFAULT_STYLE;
    private Collection<Field> fields = new ArrayList<Field>();
    private boolean extract;
    private TextAnchor textAnchor;
    private boolean optional = false;
    private boolean disabled = false;
    private boolean enforceCaptureSignature = false;
    private boolean fromFile = false;

    private SignatureBuilder(String email) {
        this.signerEmail = email;
        this.groupId = null;
        this.roleId = null;
    }

    private SignatureBuilder(GroupId groupId) {
        this.groupId = groupId;
        this.signerEmail = null;
        this.roleId = null;
    }

    private SignatureBuilder(Placeholder roleId) {
        this.groupId = null;
        this.signerEmail = null;
        this.roleId = roleId;
    }

    public static SignatureBuilder signatureFor(String signerEmail) {
        return new SignatureBuilder(signerEmail);
    }

    public static SignatureBuilder signatureFor(GroupId groupId) {
        return new SignatureBuilder(groupId);
    }

    public static SignatureBuilder signatureFor(Placeholder roleId) {
        return new SignatureBuilder(roleId);
    }

    public static SignatureBuilder acceptanceFor(String signerEmail) {
        SignatureBuilder builder = SignatureBuilder.signatureFor(signerEmail).withStyle(SignatureStyle.ACCEPTANCE).atPosition(0.0, 0.0).withSize(0.0, 0.0).onPage(0);
        return builder;
    }

    public static SignatureBuilder acceptanceFor(GroupId groupId) {
        SignatureBuilder builder = SignatureBuilder.signatureFor(groupId).withStyle(SignatureStyle.ACCEPTANCE).atPosition(0.0, 0.0).withSize(0.0, 0.0).onPage(0);
        return builder;
    }

    public static SignatureBuilder acceptanceFor(Placeholder roleId) {
        SignatureBuilder builder = SignatureBuilder.signatureFor(roleId).withStyle(SignatureStyle.ACCEPTANCE).atPosition(0.0, 0.0).withSize(0.0, 0.0).onPage(0);
        return builder;
    }

    public static SignatureBuilder initialsFor(String signerEmail) {
        return new SignatureBuilder(signerEmail).withStyle(SignatureStyle.INITIALS);
    }

    public static SignatureBuilder initialsFor(GroupId groupId) {
        return new SignatureBuilder(groupId).withStyle(SignatureStyle.INITIALS);
    }

    public static SignatureBuilder initialsFor(Placeholder roleId) {
        return new SignatureBuilder(roleId).withStyle(SignatureStyle.INITIALS);
    }

    public static SignatureBuilder captureFor(String signerEmail) {
        return new SignatureBuilder(signerEmail).withStyle(SignatureStyle.HAND_DRAWN);
    }

    public static SignatureBuilder captureFor(GroupId groupId) {
        return new SignatureBuilder(groupId).withStyle(SignatureStyle.HAND_DRAWN);
    }

    public static SignatureBuilder captureFor(Placeholder roleId) {
        return new SignatureBuilder(roleId).withStyle(SignatureStyle.HAND_DRAWN);
    }

    public static SignatureBuilder mobileCaptureFor(String signerEmail) {
        return new SignatureBuilder(signerEmail).withStyle(SignatureStyle.MOBILE_CAPTURE);
    }

    public static SignatureBuilder mobileCaptureFor(GroupId groupId) {
        return new SignatureBuilder(groupId).withStyle(SignatureStyle.MOBILE_CAPTURE);
    }

    public static SignatureBuilder mobileCaptureFor(Placeholder roleId) {
        return new SignatureBuilder(roleId).withStyle(SignatureStyle.MOBILE_CAPTURE);
    }

    public SignatureBuilder withId(SignatureId id) {
        this.id = id;
        return this;
    }

    public SignatureBuilder onPage(int pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public SignatureBuilder atPosition(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public SignatureBuilder withSize(double width, double height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public SignatureBuilder withFontSize(Integer fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public SignatureBuilder withStyle(SignatureStyle style) {
        this.style = style;
        return this;
    }

    public SignatureBuilder withField(FieldBuilder builder) {
        return this.withField(builder.build());
    }

    public SignatureBuilder withField(Field field) {
        this.fields.add(field);
        return this;
    }

    public SignatureBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public SignatureBuilder withPositionExtracted() {
        this.extract = true;
        return this;
    }

    public SignatureBuilder withPositionAnchor(TextAnchorBuilder builder) {
        return this.withPositionAnchor(builder.build());
    }

    public SignatureBuilder withPositionAnchor(TextAnchor textAnchor) {
        this.textAnchor = textAnchor;
        return this;
    }

    public SignatureBuilder setFromFile(boolean fromFile) {
        this.fromFile = fromFile;
        return this;
    }

    public SignatureBuilder makeOptional() {
        this.optional = true;
        return this;
    }

    public SignatureBuilder disabled() {
        this.disabled = true;
        return this;
    }

    public SignatureBuilder enableEnforceCaptureSignature() {
        this.enforceCaptureSignature = true;
        return this;
    }

    public Signature build() {
        Signature signature = this.roleId != null ? new Signature(this.roleId, this.pageNumber, this.x, this.y) : (this.signerEmail != null ? new Signature(this.signerEmail, this.pageNumber, this.x, this.y) : new Signature(this.groupId, this.pageNumber, this.x, this.y));
        signature.setId(this.id);
        signature.setName(this.name);
        signature.setStyle(this.style);
        signature.setWidth(this.width);
        signature.setHeight(this.height);
        signature.setFontSize(this.fontSize);
        signature.addFields(this.fields);
        signature.setExtraction(this.extract);
        signature.setTextAnchor(this.textAnchor);
        signature.setOptional(this.optional);
        signature.setDisabled(this.disabled);
        signature.setEnforceCaptureSignature(this.enforceCaptureSignature);
        signature.setFromFile(this.fromFile);
        return signature;
    }
}

