/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Placeholder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageSettingsBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CreatePackageFromTemplateWithReplacingPlaceholderExample
extends SDKSample {
    public PackageId templateId;
    public static final String DOCUMENT_NAME = "First Document";
    public static final String DOCUMENT_ID = "doc1";
    public static final String TEMPLATE_NAME = "CreatePackageFromTemplateWithReplacingPlaceholderExample Template: " + new SimpleDateFormat("HH:mm:ss").format(new Date());
    public static final String TEMPLATE_DESCRIPTION = "This is a template created using the eSignLive SDK";
    public static final String TEMPLATE_EMAIL_MESSAGE = "This message should be delivered to all signers";
    public static final String TEMPLATE_SIGNER_FIRST = "John";
    public static final String TEMPLATE_SIGNER_LAST = "Smith";
    public static final String PACKAGE_DESCRIPTION = "This is a package created using the eSignLive SDK";
    public static final String PACKAGE_EMAIL_MESSAGE = "This message should be delivered to all signers";
    public static final String PACKAGE_SIGNER_FIRST = "Patty";
    public static final String PACKAGE_SIGNER_LAST = "Galant";
    public static final String PLACEHOLDER_ID1 = "PlaceholderId1";
    public static final String PLACEHOLDER_ID2 = "PlaceholderId2";

    public static void main(String ... args) {
        new CreatePackageFromTemplateWithReplacingPlaceholderExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage template = PackageBuilder.newPackageNamed(TEMPLATE_NAME).describedAs(TEMPLATE_DESCRIPTION).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName(TEMPLATE_SIGNER_FIRST).withLastName(TEMPLATE_SIGNER_LAST).signingOrder(3)).withSigner(SignerBuilder.newSignerPlaceholder(new Placeholder(PLACEHOLDER_ID1)).signingOrder(1)).withSigner(SignerBuilder.newSignerPlaceholder(new Placeholder(PLACEHOLDER_ID2)).signingOrder(2)).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT_NAME).withId(DOCUMENT_ID).fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0)).withSignature(SignatureBuilder.signatureFor(new Placeholder(PLACEHOLDER_ID1)).onPage(0).atPosition(400.0, 100.0)).withSignature(SignatureBuilder.signatureFor(new Placeholder(PLACEHOLDER_ID2)).onPage(0).atPosition(100.0, 300.0))).build();
        this.templateId = this.eslClient.getTemplateService().createTemplate(template);
        DocumentPackage newPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs(PACKAGE_DESCRIPTION).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email2).withFirstName(PACKAGE_SIGNER_FIRST).withLastName(PACKAGE_SIGNER_LAST).replacing(new Placeholder(PLACEHOLDER_ID1))).withSigner(SignerBuilder.newSignerWithEmail(this.email3).withFirstName(PACKAGE_SIGNER_FIRST).withLastName(PACKAGE_SIGNER_LAST).replacing(new Placeholder(PLACEHOLDER_ID2))).withSigner(SignerBuilder.newSignerWithEmail(this.email4).withFirstName(PACKAGE_SIGNER_FIRST).withLastName(PACKAGE_SIGNER_LAST)).withSigner(SignerBuilder.newSignerWithEmail(this.email5).withFirstName(PACKAGE_SIGNER_FIRST).withLastName(PACKAGE_SIGNER_LAST)).withSettings(DocumentPackageSettingsBuilder.newDocumentPackageSettings().withInPerson()).build();
        this.packageId = this.eslClient.getTemplateService().createPackageFromTemplate(this.templateId, newPackage);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
    }
}

