/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.builder.SignerInformationForEquifaxCanadaBuilder;
import com.silanis.esl.sdk.builder.SignerInformationForEquifaxUSABuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import org.joda.time.DateTime;

public class MixedSignerAuthenticationExample
extends SDKSample {
    private final String PACKAGE_DESCRIPTION = "This is a mixed signer authentication example";
    private final String DOCUMENT_NAME = "First Document pdf";
    public Signer signerWithAuthenticationEquifaxCanada;
    public Signer signerWithAuthenticationEquifaxUSA;

    public static void main(String ... args) {
        new MixedSignerAuthenticationExample().run();
    }

    @Override
    public void execute() {
        this.signerWithAuthenticationEquifaxCanada = SignerBuilder.newSignerWithEmail(this.email1).withFirstName("Signer1").withLastName("Canada").challengedWithKnowledgeBasedAuthentication(SignerInformationForEquifaxCanadaBuilder.newSignerInformationForEquifaxCanada().withFirstName("Signer1").withLastName("Canada").withStreetAddress("1111").withCity("Montreal").withPostalCode("A1A1A1").withProvince("QC").withTimeAtAddress(1).withDateOfBirth(new DateTime().minusYears(25).toDate()).withDriversLicenseNumber("1234567").withSocialInsuranceNumber("123456789").withHomePhoneNumber("7943624658").build()).challengedWithQuestions(SignerBuilder.ChallengeBuilder.firstQuestion("What's your favorite restaurant? (answer: Staffany)").answer("Staffany").secondQuestion("What sport do you play? (answer: hockey)").answer("hockey")).build();
        this.signerWithAuthenticationEquifaxUSA = SignerBuilder.newSignerWithEmail(this.email2).withFirstName("Signer2").withLastName("USA").challengedWithKnowledgeBasedAuthentication(SignerInformationForEquifaxUSABuilder.newSignerInformationForEquifaxUSA().withFirstName("Signer1").withLastName("USA").withStreetAddress("2222").withCity("New York").withZip("56412").withState("NY").withDateOfBirth(new DateTime().minusYears(37).toDate()).withSocialSecurityNumber("123456789").withHomePhoneNumber("7943624658").withDriversLicenseNumber("986463565").withTimeAtAddress(15).build()).challengedWithQuestions(SignerBuilder.ChallengeBuilder.firstQuestion("What's your favorite sport? (answer: golf)").answer("golf").secondQuestion("What music instrument do you play? (answer: drums)").answer("drums")).build();
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a mixed signer authentication example").withSigner(this.signerWithAuthenticationEquifaxCanada).withSigner(this.signerWithAuthenticationEquifaxUSA).withDocument(DocumentBuilder.newDocumentWithName("First Document pdf").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).build()).withSignature(SignatureBuilder.signatureFor(this.email2).build())).build();
        this.packageId = this.eslClient.createAndSendPackage(superDuperPackage);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
    }
}

