/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal;

import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.internal.Client;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;

public class UnauthenticatedRestClient
extends Client {
    private static final String ALLOW_INVALID_SSL_CERTS = "allowAllSSLCertificates";
    private final Client.ResponseHandler<String> jsonHandler = new Client.JsonHandler(this);

    public UnauthenticatedRestClient() {
    }

    public UnauthenticatedRestClient(ProxyConfiguration proxyConfiguration) {
        this(Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty(ALLOW_INVALID_SSL_CERTS)), proxyConfiguration, false);
    }

    public UnauthenticatedRestClient(boolean allowAllSSLCertificates, ProxyConfiguration proxyConfiguration, boolean useSystemProperties) {
        this.allowAllSSLCertificates = allowAllSSLCertificates;
        this.proxyConfiguration = proxyConfiguration;
        this.useSystemProperties = useSystemProperties;
    }

    public String get(String path) throws IOException, RequestException {
        this.support.logRequest("GET", path);
        HttpGet get = new HttpGet(path);
        get.addHeader((Header)new BasicHeader("Accept", "application/json; esl-api-version=11.47"));
        return this.execute((HttpUriRequest)get, this.jsonHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(HttpUriRequest request, Client.ResponseHandler<T> handler) throws IOException, RequestException {
        CloseableHttpClient client;
        try {
            client = this.buildHttpClient();
        }
        catch (HttpException e) {
            throw new RequestException(request.getRequestLine().getMethod(), request.getRequestLine().getUri(), 500, "No SSL Socket Factory", "Could not build request because of SSL socket Factory");
        }
        try {
            CloseableHttpResponse response = client.execute(request);
            if (response.getStatusLine().getStatusCode() >= 400) {
                String errorDetails = Streams.toString(response.getEntity().getContent());
                throw new RequestException(request.getRequestLine().getMethod(), request.getRequestLine().getUri(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), errorDetails);
            }
            if (response.getStatusLine().getStatusCode() == 204) {
                T errorDetails = null;
                return errorDetails;
            }
            InputStream bodyContent = response.getEntity().getContent();
            T t = handler.extract(bodyContent);
            return t;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

