/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.silanis.esl.sdk.FieldStyle;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class FieldStyleAndSubTypeConverter {
    private static final String BINDING_DATE = "{approval.signed}";
    private static final String BINDING_TITLE = "{signer.title}";
    private static final String BINDING_NAME = "{signer.name}";
    private static final String BINDING_COMPANY = "{signer.company}";
    FieldStyle sdkFieldStyle = null;
    String apiFieldSubType = null;
    String apiFieldBinding = null;

    public FieldStyleAndSubTypeConverter(FieldStyle sdkFieldStyle) {
        this.sdkFieldStyle = sdkFieldStyle;
    }

    public FieldStyleAndSubTypeConverter(String apiFieldSubType, String apiFieldBinding) {
        this.apiFieldSubType = apiFieldSubType;
        this.apiFieldBinding = apiFieldBinding;
    }

    public String toAPIFieldSubtype() {
        if (this.sdkFieldStyle == null) {
            return this.apiFieldSubType;
        }
        return this.sdkFieldStyle.getApiValue();
    }

    public FieldStyle toSDKFieldStyle() {
        if (this.apiFieldSubType == null && this.apiFieldBinding == null) {
            return this.sdkFieldStyle;
        }
        if (this.apiFieldBinding == null) {
            try {
                return (FieldStyle)Iterables.find(Arrays.asList(FieldStyle.values()), (Predicate)new Predicate<FieldStyle>(){

                    public boolean apply(FieldStyle fieldStyle) {
                        return FieldStyleAndSubTypeConverter.this.apiFieldSubType.equals(fieldStyle.getApiValue());
                    }
                });
            }
            catch (NoSuchElementException e) {
                return FieldStyle.UNRECOGNIZED(this.apiFieldSubType);
            }
        }
        String binding = this.apiFieldBinding;
        if (binding.equals(BINDING_DATE)) {
            return FieldStyle.BOUND_DATE;
        }
        if (binding.equals(BINDING_TITLE)) {
            return FieldStyle.BOUND_TITLE;
        }
        if (binding.equals(BINDING_NAME)) {
            return FieldStyle.BOUND_NAME;
        }
        if (binding.equals(BINDING_COMPANY)) {
            return FieldStyle.BOUND_COMPANY;
        }
        return FieldStyle.UNRECOGNIZED(this.apiFieldSubType);
    }
}

