/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.Approval;
import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.FieldType;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.Placeholder;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.SignatureId;
import com.silanis.esl.sdk.SignatureStyle;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.internal.converter.ConversionService;
import com.silanis.esl.sdk.internal.converter.FieldConverter;
import com.silanis.esl.sdk.internal.converter.TextAnchorConverter;
import org.apache.commons.lang3.StringUtils;

public class SignatureConverter {
    private Signature sdkSignature = null;
    private Approval apiApproval = null;
    private Package apiPackage = null;

    public SignatureConverter(Approval apiApproval, Package apiPackage) {
        this.apiApproval = apiApproval;
        this.apiPackage = apiPackage;
    }

    public SignatureConverter(Signature sdkSignature) {
        this.sdkSignature = sdkSignature;
    }

    public Signature toSDKSignature() {
        if (this.apiPackage == null || this.apiApproval == null) {
            return this.sdkSignature;
        }
        SignatureBuilder signatureBuilder = null;
        for (Role role : this.apiPackage.getRoles()) {
            if (!role.getId().equals(this.apiApproval.getRole())) continue;
            if (SignatureConverter.isPlaceholder(role)) {
                signatureBuilder = SignatureBuilder.signatureFor(new Placeholder(role.getId()));
                continue;
            }
            if (SignatureConverter.isGroupRole(role)) {
                signatureBuilder = SignatureBuilder.signatureFor(new GroupId(role.getSigners().get(0).getGroup().getId()));
                continue;
            }
            signatureBuilder = SignatureBuilder.signatureFor(role.getSigners().get(0).getEmail());
        }
        if (this.apiApproval.getId() != null) {
            signatureBuilder.withId(new SignatureId(this.apiApproval.getId()));
        }
        signatureBuilder.withName(this.apiApproval.getName());
        com.silanis.esl.api.model.Field apiSignatureField = null;
        for (com.silanis.esl.api.model.Field apiField : this.apiApproval.getFields()) {
            if (apiField.getType().equals(FieldType.SIGNATURE.getApiValue())) {
                apiSignatureField = apiField;
                continue;
            }
            signatureBuilder.withField(new FieldConverter(apiField).toSDKField());
        }
        if (apiSignatureField == null) {
            signatureBuilder.withStyle(SignatureStyle.ACCEPTANCE);
            signatureBuilder.withSize(0.0, 0.0);
        } else {
            signatureBuilder.withStyle(SignatureStyle.fromAPIFieldSubType(apiSignatureField.getSubtype()));
            if (apiSignatureField.getPage() != null) {
                signatureBuilder.onPage(apiSignatureField.getPage());
            }
            if (apiSignatureField.getLeft() != null && apiSignatureField.getTop() != null) {
                signatureBuilder.atPosition(apiSignatureField.getLeft(), apiSignatureField.getTop());
            }
            if (apiSignatureField.getHeight() != null && apiSignatureField.getWidth() != null) {
                signatureBuilder.withSize(apiSignatureField.getWidth(), apiSignatureField.getHeight());
            }
            if (apiSignatureField.evalExtract()) {
                signatureBuilder.withPositionExtracted();
            }
            if (apiSignatureField.getFontSize() != null) {
                signatureBuilder.withFontSize(apiSignatureField.getFontSize());
            }
        }
        if (this.apiApproval.getOptional().booleanValue()) {
            signatureBuilder.makeOptional();
        }
        if (this.apiApproval.getDisabled().booleanValue()) {
            signatureBuilder.disabled();
        }
        if (this.apiApproval.getEnforceCaptureSignature().booleanValue()) {
            signatureBuilder.enableEnforceCaptureSignature();
        }
        signatureBuilder.setFromFile(this.apiApproval.getFromFile());
        Signature signature = signatureBuilder.build();
        if (null != this.apiApproval.getAccepted()) {
            signature.setAccepted(this.apiApproval.getAccepted());
        }
        return signature;
    }

    public Approval toAPIApproval() {
        if (this.sdkSignature == null) {
            return this.apiApproval;
        }
        Approval result = new Approval();
        if (this.sdkSignature.getId() != null) {
            result.setId(this.sdkSignature.getId().getId());
        }
        if (this.sdkSignature.getName() != null) {
            result.setName(this.sdkSignature.getName());
        }
        result.setOptional(this.sdkSignature.isOptional());
        result.setDisabled(this.sdkSignature.isDisabled());
        result.setEnforceCaptureSignature(this.sdkSignature.isEnforceCaptureSignature());
        result.setFromFile(this.sdkSignature.isFromFile());
        result.addField(this.getAPIFieldFromSignature());
        for (Field field : this.sdkSignature.getFields()) {
            result.addField(ConversionService.convert(field));
        }
        return result;
    }

    private static boolean isPlaceholder(Role role) {
        return role.getSigners().isEmpty();
    }

    private static boolean isGroupRole(Role role) {
        return role.getSigners().get(0).getGroup() != null;
    }

    private com.silanis.esl.api.model.Field getAPIFieldFromSignature() {
        com.silanis.esl.api.model.Field result = new com.silanis.esl.api.model.Field();
        result.setPage(this.sdkSignature.getPage());
        result.setExtract(this.sdkSignature.isExtraction());
        if (this.sdkSignature.getId() != null && StringUtils.isNotBlank((CharSequence)this.sdkSignature.getId().getId())) {
            result.setId(this.sdkSignature.getId().getId());
        }
        if (this.sdkSignature.getName() != null) {
            result.setName(this.sdkSignature.getName());
        }
        if (!this.sdkSignature.isExtraction()) {
            result.setTop(this.sdkSignature.getY());
            result.setLeft(this.sdkSignature.getX());
            result.setWidth(this.sdkSignature.getWidth());
            result.setHeight(this.sdkSignature.getHeight());
        }
        if (this.sdkSignature.getTextAnchor() != null) {
            result.setExtractAnchor(new TextAnchorConverter(this.sdkSignature.getTextAnchor()).toAPIExtractAnchor());
        }
        result.safeSetFontSize(this.sdkSignature.getFontSize());
        result.setType(FieldType.SIGNATURE.getApiValue());
        result.setSubtype(this.getSignatureSubtype());
        return result;
    }

    private String getSignatureSubtype() {
        if (this.sdkSignature == null) {
            return null;
        }
        return this.sdkSignature.getStyle().getApiValue();
    }
}

