/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.sdk.Transaction;
import com.silanis.esl.sdk.internal.converter.CreditCardConverter;
import com.silanis.esl.sdk.internal.converter.PriceConverter;

public class TransactionConverter {
    private Optional<com.silanis.esl.api.model.Transaction> apiTransactionOptional;
    private Optional<Transaction> sdkTransactionOptional;

    public TransactionConverter(com.silanis.esl.api.model.Transaction apiTransaction) {
        this.apiTransactionOptional = Optional.fromNullable((Object)apiTransaction);
        this.sdkTransactionOptional = Optional.absent();
    }

    public TransactionConverter(Transaction sdkTransaction) {
        this.apiTransactionOptional = Optional.absent();
        this.sdkTransactionOptional = Optional.fromNullable((Object)sdkTransaction);
    }

    public com.silanis.esl.api.model.Transaction toAPITransaction() {
        if (this.sdkTransactionOptional.isPresent()) {
            com.silanis.esl.api.model.Transaction apiTransaction = new com.silanis.esl.api.model.Transaction();
            Transaction sdkTransaction = (Transaction)this.sdkTransactionOptional.get();
            apiTransaction.setCreated(sdkTransaction.getCreated());
            if (sdkTransaction.getCreditCard() != null) {
                apiTransaction.setCreditCard(new CreditCardConverter(sdkTransaction.getCreditCard()).toAPICreditCard());
            }
            if (sdkTransaction.getPrice() != null) {
                apiTransaction.setPrice(new PriceConverter(sdkTransaction.getPrice()).toAPIPrice());
            }
            return apiTransaction;
        }
        return (com.silanis.esl.api.model.Transaction)this.apiTransactionOptional.orNull();
    }

    public Transaction toSDKTransaction() {
        if (this.apiTransactionOptional.isPresent()) {
            Transaction sdkTransaction = new Transaction();
            com.silanis.esl.api.model.Transaction apiTransaction = (com.silanis.esl.api.model.Transaction)this.apiTransactionOptional.get();
            sdkTransaction.setCreated(apiTransaction.getCreated());
            if (apiTransaction.getCreditCard() != null) {
                sdkTransaction.setCreditCard(new CreditCardConverter(apiTransaction.getCreditCard()).toSDKCreditCard());
            }
            if (apiTransaction.getPrice() != null) {
                sdkTransaction.setPrice(new PriceConverter(apiTransaction.getPrice()).toSDKPrice());
            }
            return sdkTransaction;
        }
        return (Transaction)this.sdkTransactionOptional.orNull();
    }
}

