/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.silanis.esl.api.model.Approval;
import com.silanis.esl.api.model.Field;
import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.Result;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.api.model.SigningUrl;
import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.CompletionReport;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentId;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentVisibility;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.FastTrackRole;
import com.silanis.esl.sdk.FastTrackSigner;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.NotaryJournalEntry;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.PackageStatus;
import com.silanis.esl.sdk.Page;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.ReferencedConditions;
import com.silanis.esl.sdk.RoleList;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.SignerId;
import com.silanis.esl.sdk.SigningStatus;
import com.silanis.esl.sdk.SupportConfiguration;
import com.silanis.esl.sdk.UsageReport;
import com.silanis.esl.sdk.Visibility;
import com.silanis.esl.sdk.builder.FastTrackRoleBuilder;
import com.silanis.esl.sdk.internal.DateHelper;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RedirectResolver;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.DocumentConverter;
import com.silanis.esl.sdk.internal.converter.DocumentPackageConverter;
import com.silanis.esl.sdk.internal.converter.DocumentVisibilityConverter;
import com.silanis.esl.sdk.internal.converter.NotaryJournalEntryConverter;
import com.silanis.esl.sdk.internal.converter.PackageStatusConverter;
import com.silanis.esl.sdk.internal.converter.ReferencedConditionsConverter;
import com.silanis.esl.sdk.internal.converter.SignerConverter;
import com.silanis.esl.sdk.internal.converter.SupportConfigurationConverter;
import com.silanis.esl.sdk.io.DownloadedFile;
import com.silanis.esl.sdk.service.ReportService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class PackageService {
    private UrlTemplate template;
    private RestClient client;
    private ReportService reportService;

    public PackageService(RestClient client, String baseUrl) {
        this.client = client;
        this.template = new UrlTemplate(baseUrl);
        this.reportService = new ReportService(client, baseUrl);
    }

    public PackageId createPackage(Package aPackage) throws EslException {
        String path = this.template.urlFor("/packages").build();
        String packageJson = Serialization.toJson(aPackage);
        try {
            String response = this.client.post(path, packageJson);
            return Serialization.fromJson(response, PackageId.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create a new package", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create a new package", e);
        }
    }

    public PackageId createPackageOneStep(Package aPackage, Collection<Document> documents) throws EslException {
        String path = this.template.urlFor("/packages").build();
        String packageJson = Serialization.toJson(aPackage);
        try {
            String response = this.client.postMultipartPackage(path, documents, packageJson);
            return Serialization.fromJson(response, PackageId.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create a new package in one-step", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create a new package in one-step", e);
        }
    }

    public PackageId createPackageFromTemplate(PackageId packageId, Package aPackage) {
        String path = this.template.urlFor("/packages/{packageId}/clone").replace("{packageId}", packageId.getId()).build();
        List<Role> roles = aPackage.getRoles();
        aPackage.setRoles(Collections.emptyList());
        String packageJson = Serialization.toJson(aPackage);
        PackageId newPackageId = null;
        try {
            String response = this.client.post(path, packageJson);
            newPackageId = Serialization.fromJson(response, PackageId.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create a new package", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create a new package", e);
        }
        Package createdPackage = this.getApiPackage(newPackageId.getId());
        for (Role role : roles) {
            String roleUid = this.findRoleUidByName(createdPackage.getRoles(), role.getName());
            if (roleUid == null) continue;
            role.setId(roleUid);
            this.updateRole(newPackageId, role);
        }
        return newPackageId;
    }

    private String findRoleUidByName(List<Role> roles, String roleName) {
        if (roleName == null || roleName.trim().isEmpty()) {
            return null;
        }
        for (Role role : roles) {
            if (!roleName.equalsIgnoreCase(role.getName())) continue;
            return role.getId();
        }
        return null;
    }

    public void updatePackage(PackageId packageId, DocumentPackage sdkPackage) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        Package aPackage = new DocumentPackageConverter(sdkPackage).toAPIPackage();
        String packageJson = Serialization.toJson(aPackage);
        try {
            this.client.put(path, packageJson);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update the package.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update the package.", e);
        }
    }

    public void changePackageStatusToDraft(PackageId packageId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        try {
            this.client.put(path, "{\"status\":\"DRAFT\"}");
        }
        catch (RequestException e) {
            throw new EslServerException("Could not change the package status to DRAFT.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not change the package status to DRAFT.", e);
        }
    }

    public void configureDocumentVisibility(PackageId packageId, DocumentVisibility visibility) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/visibility").replace("{packageId}", packageId.getId()).build();
        com.silanis.esl.api.model.DocumentVisibility apiVisibility = new DocumentVisibilityConverter(visibility).toAPIDocumentVisibility();
        String json = Serialization.toJson(apiVisibility);
        try {
            this.client.post(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not configure document visibility.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not configure document visibility.", e);
        }
    }

    public DocumentVisibility getDocumentVisibility(PackageId packageId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/visibility").replace("{packageId}", packageId.getId()).build();
        try {
            String response = this.client.get(path);
            com.silanis.esl.api.model.DocumentVisibility apiVisibility = Serialization.fromJson(response, com.silanis.esl.api.model.DocumentVisibility.class);
            return new DocumentVisibilityConverter(apiVisibility).toSDKDocumentVisibility();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get document visibility.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get document visibility.", e);
        }
    }

    public DocumentPackage getPackage(PackageId packageId) {
        Package aPackage = this.getApiPackage(packageId.getId());
        DocumentPackage documentPackage = this.packageConverter(aPackage).toSDKPackage();
        return documentPackage;
    }

    public List<Document> getDocuments(PackageId packageId, String signerId) {
        DocumentPackage documentPackage = this.getPackage(packageId);
        DocumentVisibility visibility = this.getDocumentVisibility(packageId);
        return visibility.getDocuments(documentPackage, signerId);
    }

    public List<Signer> getSigners(PackageId packageId, String documentId) {
        DocumentPackage documentPackage = this.getPackage(packageId);
        DocumentVisibility visibility = this.getDocumentVisibility(packageId);
        return visibility.getSigners(documentPackage, documentId);
    }

    private DocumentPackageConverter packageConverter(Package aPackage) {
        return new DocumentPackageConverter(aPackage);
    }

    public Package getApiPackage(String packageId) throws EslException {
        String stringResponse;
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId).build();
        try {
            stringResponse = this.client.get(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get package.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get package.", e);
        }
        return Serialization.fromJson(stringResponse, Package.class);
    }

    @Deprecated
    public Document uploadDocument(PackageId packageId, String fileName, byte[] fileBytes, Document document, DocumentPackage documentPackage) throws EslException {
        return this.uploadDocument(packageId, fileName, fileBytes, document);
    }

    public Document uploadDocument(PackageId packageId, String fileName, byte[] fileBytes, Document document) throws EslException {
        Package apiPackage = this.getApiPackage(packageId.getId());
        com.silanis.esl.api.model.Document apiDocument = new DocumentConverter(document).toAPIDocument(apiPackage);
        return this.uploadApiDocument(packageId.getId(), fileName, fileBytes, apiDocument);
    }

    public Document uploadApiDocument(String packageId, String fileName, byte[] fileBytes, com.silanis.esl.api.model.Document document) {
        String path = this.template.urlFor("/packages/{packageId}/documents").replace("{packageId}", packageId).build();
        String documentJson = Serialization.toJson(document);
        try {
            String response = this.client.postMultipartFile(path, fileName, fileBytes, documentJson);
            com.silanis.esl.api.model.Document uploadedDocument = Serialization.fromJson(response, com.silanis.esl.api.model.Document.class);
            return new DocumentConverter(uploadedDocument, this.getApiPackage(packageId)).toSDKDocument();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not upload document to package.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not upload document to package.", e);
        }
    }

    public List<Document> uploadDocuments(final String packageId, List<Document> documents) {
        String path = this.template.urlFor("/packages/{packageId}/documents").replace("{packageId}", packageId).build();
        final Package apiPackage = this.getApiPackage(packageId);
        ArrayList apiDocuments = Lists.newArrayList((Iterable)Iterables.transform(documents, (Function)new Function<Document, com.silanis.esl.api.model.Document>(){

            public com.silanis.esl.api.model.Document apply(Document input) {
                return new DocumentConverter(input).toAPIDocument(apiPackage);
            }
        }));
        String documentsJson = Serialization.toJson(apiDocuments);
        try {
            String response = this.client.postMultipartPackage(path, documents, documentsJson);
            List<com.silanis.esl.api.model.Document> uploadedDocuments = Serialization.fromJsonToList(response, com.silanis.esl.api.model.Document.class);
            return Lists.newArrayList((Iterable)Iterables.transform(uploadedDocuments, (Function)new Function<com.silanis.esl.api.model.Document, Document>(){

                public Document apply(com.silanis.esl.api.model.Document input) {
                    return new DocumentConverter(input, PackageService.this.getApiPackage(packageId)).toSDKDocument();
                }
            }));
        }
        catch (RequestException e) {
            throw new EslServerException("Could not upload documents to package.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not upload documents to package.", e);
        }
    }

    public void deleteDocument(PackageId packageId, String documentId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).build();
        try {
            this.client.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete document from package.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete document from package.", e);
        }
    }

    public void deleteDocuments(PackageId packageId, DocumentId ... documentIds) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents").replace("{packageId}", packageId.getId()).build();
        try {
            String json = Serialization.toJson(Lists.transform(Arrays.asList(documentIds), (Function)new Function<DocumentId, String>(){

                public String apply(DocumentId documentId) {
                    return documentId.getId();
                }
            }));
            this.client.delete(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete documents from package.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete documents from package.", e);
        }
    }

    public Document getDocumentMetadata(DocumentPackage documentPackage, String documentId) {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}").replace("{packageId}", documentPackage.getId().getId()).replace("{documentId}", documentId).build();
        try {
            String response = this.client.get(path);
            com.silanis.esl.api.model.Document apilDocument = Serialization.fromJson(response, com.silanis.esl.api.model.Document.class);
            apilDocument.setApprovals(new ArrayList<Approval>());
            apilDocument.setFields(new ArrayList<Field>());
            apilDocument.setPages(new ArrayList<com.silanis.esl.api.model.Page>());
            return new DocumentConverter(apilDocument, new DocumentPackageConverter(documentPackage).toAPIPackage()).toSDKDocument();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the document's metadata.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the document's metadata. Exception: " + e.getMessage());
        }
    }

    public void updateDocumentMetadata(DocumentPackage documentPackage, Document document) {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}").replace("{packageId}", documentPackage.getId().getId()).replace("{documentId}", document.getId().toString()).build();
        com.silanis.esl.api.model.Document internalDoc = new DocumentConverter(document).toAPIDocumentMetadata();
        try {
            String json = Serialization.toJson(internalDoc);
            this.client.put(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update the document's metadata.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update the document's metadata. Exception: " + e.getMessage());
        }
    }

    public void orderDocuments(DocumentPackage documentPackage) {
        String path = this.template.urlFor("/packages/{packageId}/documents").replace("{packageId}", documentPackage.getId().getId()).build();
        ArrayList<com.silanis.esl.api.model.Document> documents = new ArrayList<com.silanis.esl.api.model.Document>();
        for (Document document : documentPackage.getDocuments()) {
            documents.add(new DocumentConverter(document).toAPIDocumentMetadata());
        }
        try {
            String json = Serialization.toJson(documents);
            this.client.put(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not order the documents.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not order the documents. Exception: " + e.getMessage());
        }
    }

    public void addDocumentWithExternalContent(String packageId, List<Document> providerDocuments) {
        String path = this.template.urlFor("/packages/{packageId}/documents").replace("{packageId}", packageId).build();
        ArrayList<com.silanis.esl.api.model.Document> apiDocuments = new ArrayList<com.silanis.esl.api.model.Document>();
        for (Document document : providerDocuments) {
            apiDocuments.add(new DocumentConverter(document).toAPIDocumentMetadata());
        }
        try {
            String json = Serialization.toJson(apiDocuments);
            this.client.post(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not upload the documents.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not upload the documents. Exception: " + e.getMessage());
        }
    }

    public List<Document> getDocuments() {
        String path = this.template.urlFor("/documents").build();
        try {
            String stringResponse = this.client.get(path);
            List<com.silanis.esl.api.model.Document> apiResponse = JacksonUtil.deserialize(stringResponse, new TypeReference<List<com.silanis.esl.api.model.Document>>(){});
            ArrayList<Document> documents = new ArrayList<Document>();
            for (com.silanis.esl.api.model.Document document : apiResponse) {
                documents.add(new DocumentConverter(document, null).toSDKDocument());
            }
            return documents;
        }
        catch (RequestException e) {
            throw new EslServerException("Failed to retrieve documents from history List.", e);
        }
        catch (Exception e) {
            throw new EslException("Failed to retrieve documents from history list.", e);
        }
    }

    public void sendPackage(PackageId packageId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        String json = "{\"status\":\"SENT\"}";
        try {
            this.client.post(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not send the package.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not send the package.", e);
        }
    }

    public List<Role> getRoles(PackageId packageId) throws EslException {
        String stringResponse;
        String path = this.template.urlFor("/packages/{packageId}/roles").replace("{packageId}", packageId.getId()).build();
        try {
            stringResponse = this.client.get(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not retrieve list of roles for package with id " + packageId.getId(), e);
        }
        catch (Exception e) {
            throw new EslException("Could not retrieve list of roles for package with id " + packageId.getId(), e);
        }
        return Serialization.fromJson(stringResponse, RoleList.class).getResults();
    }

    public Role addRole(PackageId packageId, Role role) throws EslException {
        String stringResponse;
        String path = this.template.urlFor("/packages/{packageId}/roles").replace("{packageId}", packageId.getId()).build();
        String roleJson = JacksonUtil.serializeDirty(role);
        try {
            stringResponse = this.client.post(path, roleJson);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not add role.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not add role.", e);
        }
        return Serialization.fromJson(stringResponse, Role.class);
    }

    public Role updateRole(PackageId packageId, Role role) throws EslException {
        String stringResponse;
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}").replace("{packageId}", packageId.getId()).replace("{roleId}", role.getId()).build();
        String roleJson = JacksonUtil.serializeDirty(role);
        try {
            stringResponse = this.client.put(path, roleJson);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update role", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update role", e);
        }
        return Serialization.fromJson(stringResponse, Role.class);
    }

    public void deleteRole(PackageId packageId, Role role) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}").replace("{packageId}", packageId.getId()).replace("{roleId}", role.getId()).build();
        try {
            this.client.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete role", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete role", e);
        }
    }

    public byte[] downloadDocument(PackageId packageId, com.silanis.esl.api.model.Document document) throws EslException {
        return this.downloadDocument(packageId, document.getId());
    }

    public byte[] downloadDocument(PackageId packageId, String documentId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/pdf").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).build();
        try {
            return this.client.getBytesAsOctetStream(path).getContents();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the pdf document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the pdf document.", e);
        }
    }

    public byte[] downloadOriginalDocument(PackageId packageId, String documentId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/original").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).build();
        try {
            return this.client.getBytesAsOctetStream(path).getContents();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the original document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the original document.", e);
        }
    }

    public byte[] downloadZippedDocuments(PackageId packageId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/documents/zip").replace("{packageId}", packageId.getId()).build();
        try {
            return this.client.getBytes(path).getContents();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the documents to a zip file.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the documents to a zip file.", e);
        }
    }

    public byte[] downloadEvidenceSummary(PackageId packageId) throws EslException {
        String path = this.template.urlFor("/packages/{packageId}/evidence/summary").replace("{packageId}", packageId.getId()).build();
        try {
            return this.client.getBytes(path).getContents();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the evidence summary.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the evidence summary.", e);
        }
    }

    public SigningStatus getSigningStatus(PackageId packageId, SignerId signerId, DocumentId documentId) {
        String path = this.template.urlFor("/packages/{packageId}/signingStatus?signer={signerId}&document={documentId}").replace("{packageId}", packageId.getId()).replace("{signerId}", signerId != null ? signerId.getId() : "").replace("{documentId}", documentId != null ? documentId.getId() : "").build();
        try {
            String stringResponse = this.client.get(path);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode topNode = objectMapper.readTree(stringResponse);
            String statusString = topNode.get("status").textValue();
            return SigningStatus.statusForToken(statusString);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not retrieve signing status.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not retrieve signing status.", e);
        }
    }

    public Page<DocumentPackage> getPackages(String status, PageRequest request) {
        String path = this.template.urlFor("/packages?query={status}&from={from}&to={to}").replace("{status}", status).replace("{from}", Integer.toString(request.getFrom())).replace("{to}", Integer.toString(request.to())).build();
        try {
            String response = this.client.get(path);
            Result<Package> results = JacksonUtil.deserialize(response, new TypeReference<Result<Package>>(){});
            return this.convertToPage(results, request);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get package list.", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EslException("Could not get package list. Exception: " + e.getMessage());
        }
    }

    public Page<Map<String, String>> getPackagesFields(PackageStatus status, PageRequest request, Set<String> fields) {
        String path = this.template.urlFor("/packages?query={status}&from={from}&to={to}&fields={fields}").replace("{status}", new PackageStatusConverter(status).toAPIPackageStatus()).replace("{from}", Integer.toString(request.getFrom())).replace("{to}", Integer.toString(request.to())).replace("{fields}", StringUtils.join(fields, (String)",")).build();
        try {
            String response = this.client.get(path);
            Result<Map<String, String>> results = JacksonUtil.deserialize(response, new TypeReference<Result<Map<String, String>>>(){});
            return new Page<Map<String, String>>(results.getResults(), results.getCount(), request);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get package list.", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EslException("Could not get package list. Exception: " + e.getMessage());
        }
    }

    public Page<DocumentPackage> getUpdatedPackagesWithinDateRange(PackageStatus status, PageRequest request, Date from, Date to) {
        String fromDate = DateHelper.dateToIsoUtcFormat(from);
        String toDate = DateHelper.dateToIsoUtcFormat(to);
        String path = this.template.urlFor("/packages?query={status}&from={from}&to={to}&lastUpdatedStartDate={lastUpdatedStartDate}&lastUpdatedEndDate={lastUpdatedEndDate}").replace("{status}", new PackageStatusConverter(status).toAPIPackageStatus()).replace("{from}", Integer.toString(request.getFrom())).replace("{to}", Integer.toString(request.to())).replace("{lastUpdatedStartDate}", fromDate).replace("{lastUpdatedEndDate}", toDate).build();
        try {
            String response = this.client.get(path);
            Result<Package> results = JacksonUtil.deserialize(response, new TypeReference<Result<Package>>(){});
            return this.convertToPage(results, request);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get package list.", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EslException("Could not get package list. Exception: " + e.getMessage());
        }
    }

    private Page<DocumentPackage> convertToPage(Result<Package> results, PageRequest request) {
        ArrayList<DocumentPackage> converted = new ArrayList<DocumentPackage>();
        for (Package aPackage : results.getResults()) {
            DocumentPackage dp = new DocumentPackageConverter(aPackage).toSDKPackage();
            converted.add(dp);
        }
        return new Page<DocumentPackage>(converted, results.getCount(), request);
    }

    public void deletePackage(PackageId packageId) {
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        try {
            this.client.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to delete package.", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EslException("Unable to delete package. Exception: " + e.getMessage());
        }
    }

    public void restore(PackageId packageId) {
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        String json = "{\"trashed\":false}";
        try {
            this.client.post(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to restore the package.", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EslException("Unable to restore the package. Exception: " + e.getMessage());
        }
    }

    public void trash(PackageId packageId) {
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        String json = "{\"trashed\":true}";
        try {
            this.client.post(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to trash the package.", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EslException("Unable to trash the package. Exception: " + e.getMessage());
        }
    }

    public void archive(PackageId packageId) {
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        String json = "{\"status\":\"ARCHIVED\"}";
        try {
            this.client.post(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to archive the package.", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EslException("Unable to archive the package. Exception: " + e.getMessage());
        }
    }

    public void markComplete(PackageId packageId) {
        String path = this.template.urlFor("/packages/{packageId}").replace("{packageId}", packageId.getId()).build();
        String json = "{\"status\":\"COMPLETED\"}";
        try {
            this.client.post(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to mark complete on the package.", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EslException("Unable to mark complete on the package. Exception: " + e.getMessage());
        }
    }

    public void notifySigner(PackageId packageId, String signerEmail, String message) {
        String path = this.template.urlFor("/packages/{packageId}/notifications").replace("{packageId}", packageId.getId()).build();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("email", signerEmail);
        jsonMap.put("message", message);
        try {
            String payload = JacksonUtil.serialize(jsonMap);
            this.client.post(path, payload);
        }
        catch (RequestException e) {
            throw new EslException("Could not send email notification to signer.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not send email notification to signer. Exception: " + e.getMessage());
        }
    }

    private Role findRoleForGroup(PackageId packageId, String groupId) {
        List<Role> roles = this.getRoles(packageId);
        for (Role role : roles) {
            com.silanis.esl.api.model.Signer signer;
            if (role.getSigners().isEmpty() || (signer = role.getSigners().get(0)).getGroup() == null || !signer.getGroup().getId().equals(groupId)) continue;
            return role;
        }
        return null;
    }

    public void notifySigner(PackageId packageId, GroupId groupId) {
        Role role = this.findRoleForGroup(packageId, groupId.getId());
        this.notifySigner(packageId, role.getId());
    }

    private void notifySigner(PackageId packageId, String roleId) {
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}/notifications").replace("{packageId}", packageId.getId()).replace("{roleId}", roleId).build();
        try {
            this.client.post(path, null);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not send email notification.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not send email notification.  " + e.getMessage());
        }
    }

    public Page<DocumentPackage> getTemplates(PageRequest request) {
        String path = this.template.urlFor("/packages").addParam("type", "template").addParam("from", Integer.toString(request.getFrom())).addParam("to", Integer.toString(request.to())).build();
        return this.getTemplates(request, path);
    }

    public Page<DocumentPackage> getTemplates(PageRequest request, Visibility visibility) {
        String path = this.template.urlFor("/packages").addParam("type", "template").addParam("from", Integer.toString(request.getFrom())).addParam("to", Integer.toString(request.to())).addParam("visibility", visibility.name()).build();
        return this.getTemplates(request, path);
    }

    private Page<DocumentPackage> getTemplates(PageRequest request, String path) {
        try {
            String response = this.client.get(path);
            Result<Package> results = JacksonUtil.deserialize(response, new TypeReference<Result<Package>>(){});
            return this.convertToPage(results, request);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get template list.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get template list. Exception: " + e.getMessage());
        }
    }

    public String addSigner(PackageId packageId, Signer signer) {
        Role apiPayload = new SignerConverter(signer).toAPIRole(UUID.randomUUID().toString().replace("-", ""));
        String path = this.template.urlFor("/packages/{packageId}/roles").replace("{packageId}", packageId.getId()).build();
        try {
            String json = Serialization.toJson(apiPayload);
            String response = this.client.post(path, json);
            Role apiRole = Serialization.fromJson(response, Role.class);
            return apiRole.getId();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not add signer.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not add signer. Exception: " + e.getMessage());
        }
    }

    public Signer getSigner(PackageId packageId, String signerId) {
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}").replace("{packageId}", packageId.getId()).replace("{roleId}", signerId).build();
        try {
            String response = this.client.get(path);
            Role apiRole = Serialization.fromJson(response, Role.class);
            return new SignerConverter(apiRole).toSDKSigner();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get signer.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get signer. Exception: " + e.getMessage());
        }
    }

    public void removeSigner(PackageId packageId, String signerId) {
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}").replace("{packageId}", packageId.getId()).replace("{roleId}", signerId).build();
        try {
            this.client.delete(path);
            return;
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete signer.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete signer. Exception: " + e.getMessage());
        }
    }

    public void orderSigners(DocumentPackage documentPackage) {
        String path = this.template.urlFor("/packages/{packageId}/roles").replace("{packageId}", documentPackage.getId().getId()).build();
        ArrayList<Role> roles = new ArrayList<Role>();
        for (Signer signer : documentPackage.getSigners()) {
            roles.add(new SignerConverter(signer).toAPIRole(signer.getId()));
        }
        try {
            String json = Serialization.toJson(roles);
            this.client.put(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not order signers.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not order signers. Exception: " + e.getMessage());
        }
    }

    public void updateSigner(PackageId packageId, Signer signer) {
        Role apiPayload = new SignerConverter(signer).toAPIRole(UUID.randomUUID().toString().replace("-", ""));
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}").replace("{packageId}", packageId.getId()).replace("{roleId}", signer.getId()).build();
        try {
            String json = Serialization.toJson(apiPayload);
            this.client.put(path, json);
        }
        catch (RequestException e) {
            throw new EslException("Could not update signer.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update signer. Exception: " + e.getMessage());
        }
    }

    public void unlockSigner(PackageId packageId, String signerId) {
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}/unlock").replace("{packageId}", packageId.getId()).replace("{roleId}", signerId).build();
        try {
            this.client.post(path, null);
        }
        catch (RequestException e) {
            throw new EslException("Could not unlock signer.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not unlock signer. Exception: " + e.getMessage());
        }
    }

    @Deprecated
    public CompletionReport downloadCompletionReport(PackageStatus packageStatus, String senderId, Date from, Date to) {
        return this.reportService.downloadCompletionReport(packageStatus, senderId, from, to);
    }

    @Deprecated
    public String downloadCompletionReportAsCSV(PackageStatus packageStatus, String senderId, Date from, Date to) {
        return this.reportService.downloadCompletionReportAsCSV(packageStatus, senderId, from, to);
    }

    @Deprecated
    public CompletionReport downloadCompletionReport(PackageStatus packageStatus, Date from, Date to) {
        return this.reportService.downloadCompletionReport(packageStatus, from, to);
    }

    @Deprecated
    public String downloadCompletionReportAsCSV(PackageStatus packageStatus, Date from, Date to) {
        return this.reportService.downloadCompletionReportAsCSV(packageStatus, from, to);
    }

    @Deprecated
    public UsageReport downloadUsageReport(Date from, Date to) {
        return this.reportService.downloadUsageReport(from, to);
    }

    @Deprecated
    public String downloadUsageReportAsCSV(Date from, Date to) {
        return this.reportService.downloadUsageReportAsCSV(from, to);
    }

    public String getSigningUrl(PackageId packageId, String signerId) {
        Package aPackage = this.getApiPackage(packageId.getId());
        return this.getSigningUrl(packageId, this.getRole(aPackage, signerId));
    }

    private Role getRole(Package apiPackage, String sigenrId) {
        for (Role role : apiPackage.getRoles()) {
            for (com.silanis.esl.api.model.Signer signer : role.getSigners()) {
                if (!signer.getId().equals(sigenrId)) continue;
                return role;
            }
        }
        return new Role();
    }

    private Role getRoleByEmail(Package apiPackage, String signerEmail) {
        for (Role role : apiPackage.getRoles()) {
            for (com.silanis.esl.api.model.Signer signer : role.getSigners()) {
                if (!signer.getEmail().equals(signerEmail)) continue;
                return role;
            }
        }
        return new Role();
    }

    private String getSigningUrl(PackageId packageId, Role role) {
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}/signingUrl").replace("{packageId}", packageId.getId()).replace("{roleId}", role.getId()).build();
        try {
            String response = this.client.get(path);
            SigningUrl signingUrl = Serialization.fromJson(response, SigningUrl.class);
            return signingUrl.getUrl();
        }
        catch (RequestException e) {
            throw new EslException("Could not get a signing url.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get a signing url. Exception: " + e.getMessage());
        }
    }

    public String startFastTrack(PackageId packageId, List<FastTrackSigner> signers) {
        String token = this.getFastTrackToken(packageId, true);
        String path = this.template.urlFor("/fastTrack?token={token}").replace("{token}", token).build();
        ArrayList<FastTrackRole> roles = new ArrayList<FastTrackRole>();
        for (FastTrackSigner signer : signers) {
            FastTrackRole role = FastTrackRoleBuilder.newRoleWithId(signer.getId()).withName(signer.getId()).withSigner(signer).build();
            roles.add(role);
        }
        String json = Serialization.toJson(roles);
        try {
            String response = this.client.post(path, json);
            SigningUrl signingUrl = Serialization.fromJson(response, SigningUrl.class);
            return signingUrl.getUrl();
        }
        catch (RequestException e) {
            throw new EslException("Could not start fast track.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not start fast track. Exception: " + e.getMessage());
        }
    }

    private String getFastTrackToken(PackageId packageId, Boolean signing) {
        String fastTrackUrl = this.getFastTrackUrl(packageId, signing);
        String finalUrl = RedirectResolver.resolveUrlAfterRedirect(fastTrackUrl);
        String[] split = StringUtils.split((String)finalUrl, (char)'=');
        return split[split.length - 1];
    }

    private String getFastTrackUrl(PackageId packageId, Boolean signing) {
        String path = this.template.urlFor("/fastTrack/{packageId}/url?signing={signing}").replace("{packageId}", packageId.getId()).replace("{signing}", signing.toString()).build();
        try {
            String json = this.client.get(path);
            SigningUrl signingUrl = Serialization.fromJson(json, SigningUrl.class);
            return signingUrl.getUrl();
        }
        catch (RequestException e) {
            throw new EslException("Could not get a fastTrack url.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get a fastTrack url. Exception: " + e.getMessage());
        }
    }

    public void sendSmsToSigner(PackageId packageId, Signer signer) {
        Role role = new SignerConverter(signer).toAPIRole(UUID.randomUUID().toString().replace("-", ""));
        this.sendSmsToSigner(packageId, role);
    }

    private void sendSmsToSigner(PackageId packageId, Role role) {
        String path = this.template.urlFor("/packages/{packageId}/roles/{roleId}/sms_notification").replace("{packageId}", packageId.getId()).replace("{roleId}", role.getId()).build();
        try {
            this.client.post(path, null);
        }
        catch (RequestException e) {
            throw new EslException("Could not send SMS to the signer.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not send SMS to the signer. Exception: " + e.getMessage());
        }
    }

    public List<NotaryJournalEntry> getJournalEntries(String userId) {
        ArrayList<NotaryJournalEntry> result = new ArrayList<NotaryJournalEntry>();
        String path = this.template.urlFor("/user/{userId}/journal").replace("{userId}", userId).build();
        try {
            String stringResponse = this.client.get(path);
            Result<com.silanis.esl.api.model.NotaryJournalEntry> apiResponse = JacksonUtil.deserialize(stringResponse, new TypeReference<Result<com.silanis.esl.api.model.NotaryJournalEntry>>(){});
            for (com.silanis.esl.api.model.NotaryJournalEntry apiNotaryJournalEntry : apiResponse.getResults()) {
                result.add(new NotaryJournalEntryConverter(apiNotaryJournalEntry).toSDKNotaryJournalEntry());
            }
            return result;
        }
        catch (RequestException e) {
            throw new EslException("Could not get Journal Entries.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get Journal Entries. Exception: " + e.getMessage());
        }
    }

    public DownloadedFile getJournalEntriesAsCSV(String userId) {
        String path = this.template.urlFor("/user/{userId}/journal/download").replace("{userId}", userId).build();
        try {
            return this.client.getBytes(path);
        }
        catch (RequestException e) {
            throw new EslException("Could not get Journal Entries in csv.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get Journal Entries in csv. Exception: " + e.getMessage());
        }
    }

    public String getThankYouDialogContent(PackageId packageId) {
        String path = this.template.urlFor("/packages/{packageId}/thank_you_dialog").replace("{packageId}", packageId.getId()).build();
        try {
            String json = this.client.get(path);
            Properties thankYouDialogContent = Serialization.fromJson(json, Properties.class);
            return thankYouDialogContent.getProperty("body");
        }
        catch (RequestException e) {
            throw new EslException("Could not get thank you dialog content.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get thank you dialog content. Exception: " + e.getMessage());
        }
    }

    public SupportConfiguration getConfig(PackageId packageId) {
        String path = this.template.urlFor("/package_information/{packageId}/support_information").replace("{packageId}", packageId.getId()).build();
        try {
            String json = this.client.get(path);
            com.silanis.esl.api.model.SupportConfiguration apiSupportConfiguration = Serialization.fromJson(json, com.silanis.esl.api.model.SupportConfiguration.class);
            return new SupportConfigurationConverter(apiSupportConfiguration).toSDKSupportConfiguration();
        }
        catch (RequestException e) {
            throw new EslException("Could not get support configuration.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get support configuration. Exception: " + e.getMessage());
        }
    }

    public ReferencedConditions getReferencedConditions(String packageId) {
        return this.getReferencedConditions(packageId, null, null);
    }

    public ReferencedConditions getReferencedConditions(String packageId, String documentId) {
        return this.getReferencedConditions(packageId, documentId, null);
    }

    public ReferencedConditions getReferencedConditions(String packageId, String documentId, String fieldId) {
        String stringResponse;
        String path = this.template.urlFor("/packages/{packageId}/referencedConditions").replace("{packageId}", packageId).addParam("documentId", documentId).addParam("fieldId", fieldId).build();
        try {
            stringResponse = this.client.get(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get referenced conditions.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get referenced conditions.", e);
        }
        com.silanis.esl.api.model.ReferencedConditions apiReferencedConditions = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.ReferencedConditions.class);
        return ReferencedConditionsConverter.toSDK(apiReferencedConditions);
    }
}

