/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.Document;
import com.silanis.esl.api.model.SignedDocument;
import com.silanis.esl.api.model.SignedDocuments;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import java.util.Map;

public class SigningService {
    private final UrlTemplate template;
    private final RestClient client;

    public SigningService(RestClient client, String baseUrl) {
        this.template = new UrlTemplate(baseUrl);
        this.client = client;
    }

    public void signDocument(PackageId packageId, SignedDocument signedDocument) {
        String path = this.template.urlFor("/packages/{packageId}/documents/signConfirm").replace("{packageId}", packageId.getId()).build();
        try {
            this.client.post(path, Serialization.toJson(signedDocument));
        }
        catch (RequestException e) {
            throw new EslServerException("Failed to sign a document.", e);
        }
        catch (Exception e) {
            throw new EslException("Failed to sign a document.", e);
        }
    }

    public void signDocuments(PackageId packageId, SignedDocuments signedDocumentses) {
        String path = this.template.urlFor("/packages/{packageId}/documents/signed_documents").replace("{packageId}", packageId.getId()).build();
        try {
            this.client.post(path, Serialization.toJson(signedDocumentses));
        }
        catch (RequestException e) {
            throw new EslServerException("Failed to sign documents.", e);
        }
        catch (Exception e) {
            throw new EslException("Failed to sign documents.", e);
        }
    }

    public SignedDocument convertToSignedDocument(Document document) {
        SignedDocument signedDocument = new SignedDocument();
        signedDocument.setId(document.getId());
        signedDocument.setName(document.getName());
        signedDocument.setDescription(document.getDescription());
        signedDocument.setApprovals(document.getApprovals());
        signedDocument.setExternal(document.getExternal());
        signedDocument.setIndex(document.getIndex());
        signedDocument.setExtract(document.getExtract());
        signedDocument.setExtractionTypes(document.getExtractionTypes());
        signedDocument.setFields(document.getFields());
        signedDocument.setData((Map)document.getData());
        signedDocument.setSignedHash(document.getSignedHash());
        signedDocument.setPages(document.getPages());
        signedDocument.setSize(document.getSize());
        signedDocument.setStatus(document.getStatus());
        signedDocument.setSignerVerificationToken(document.getSignerVerificationToken());
        signedDocument.setTagged(document.getTagged());
        return signedDocument;
    }
}

