/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.google.common.collect.Sets;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentId;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.External;
import com.silanis.esl.sdk.ExtractionType;
import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.builder.BuilderException;
import com.silanis.esl.sdk.builder.DocumentAttributesBuilder;
import com.silanis.esl.sdk.builder.DocumentSource;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.internal.FileDocumentSource;
import com.silanis.esl.sdk.builder.internal.StreamDocumentSource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DocumentBuilder {
    public static final String DEFAULT_NAME = "New Document";
    private String name = "New Document";
    private final List<Signature> signatures;
    private DocumentSource documentSource;
    private String fileName;
    private int index;
    private boolean extract;
    private boolean externalSignedDocument;
    private Set<String> extractionTypes = Sets.newHashSet();
    private String id = null;
    private List<Field> injectedFields = new ArrayList<Field>();
    private List<Field> qrCodes = new ArrayList<Field>();
    private String description;
    private External external;
    private Map<String, Object> data = new LinkedHashMap<String, Object>();

    public DocumentBuilder() {
        this.signatures = new ArrayList<Signature>();
    }

    public DocumentBuilder(String name) {
        this();
        this.name = name;
    }

    public static DocumentBuilder newDocumentWithName(String name) {
        return new DocumentBuilder(name);
    }

    public DocumentBuilder enableExtraction() {
        this.extract = true;
        return this;
    }

    public DocumentBuilder withExternalSignedDocument() {
        this.externalSignedDocument = true;
        return this;
    }

    public DocumentBuilder fromFile(String fileName) {
        this.fileName = fileName;
        this.documentSource = new FileDocumentSource(fileName);
        return this;
    }

    public DocumentBuilder fromStream(InputStream input, DocumentType type) {
        this.documentSource = new StreamDocumentSource(input);
        this.fileName = type.normalizeName(this.name);
        return this;
    }

    public DocumentBuilder withSignature(SignatureBuilder builder) {
        return this.withSignature(builder.build());
    }

    public DocumentBuilder withSignature(Signature signature) {
        this.signatures.add(signature);
        return this;
    }

    public DocumentBuilder withExternal(External external) {
        this.external = external;
        return this;
    }

    private void validate() {
        if (this.id == null && this.fileName == null && this.documentSource == null) {
            throw new BuilderException("Document fileName or Content must be set.");
        }
    }

    public Document build() {
        this.validate();
        Document document = new Document();
        document.setName(this.name);
        document.setFileName(this.fileName);
        document.setContent(this.documentSource != null ? this.documentSource.content() : null);
        document.addSignatures(this.signatures);
        document.setIndex(this.index);
        document.setExtraction(this.extract);
        document.setExtractionTypes(this.extractionTypes);
        document.setExternal(this.external);
        if (this.description != null) {
            document.setDescription(this.description);
        }
        if (this.id != null) {
            document.setId(new DocumentId(this.id));
        }
        document.addInjectedFields(this.injectedFields);
        document.addQRCodes(this.qrCodes);
        document.setData(this.data);
        document.setExternalSigned(this.externalSignedDocument);
        return document;
    }

    public DocumentBuilder atIndex(int index) {
        this.index = index;
        return this;
    }

    public DocumentBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public DocumentBuilder withInjectedField(FieldBuilder builder) {
        return this.withInjectedField(builder.build());
    }

    public DocumentBuilder withInjectedField(Field field) {
        this.injectedFields.add(field);
        return this;
    }

    public DocumentBuilder withQRCode(FieldBuilder builder) {
        return this.withQRCode(builder.build());
    }

    public DocumentBuilder withQRCode(Field field) {
        this.qrCodes.add(field);
        return this;
    }

    public DocumentBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public DocumentBuilder withData(Map<String, Object> data) {
        if (data != null) {
            this.data.putAll(data);
        }
        return this;
    }

    public DocumentBuilder withData(DocumentAttributesBuilder builder) {
        this.data.putAll(builder.build());
        return this;
    }

    public DocumentBuilder withExtractionType(ExtractionType extractionType) {
        this.extractionTypes.add(extractionType.name());
        return this;
    }
}

