/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.AuthenticationClient;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.builder.AccountMemberBuilder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SenderInfoBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.logging.Logger;

public class DesignerRedirectForPackageSenderExample
extends SDKSample {
    private static final Logger logger = Logger.getLogger(DesignerRedirectForPackageSenderExample.class.getName());
    private AuthenticationClient authenticationClient;
    public String generatedLinkToDesignerForSender;

    public static void main(String ... args) {
        new DesignerRedirectForPackageSenderExample().run();
    }

    public DesignerRedirectForPackageSenderExample() {
        this.authenticationClient = new AuthenticationClient(this.webpageUrl);
    }

    @Override
    public void execute() {
        this.eslClient.getAccountService().inviteUser(AccountMemberBuilder.newAccountMember(this.senderEmail).withFirstName("firstName").withLastName("lastName").withCompany("company").withTitle("title").withLanguage("language").withPhoneNumber("phoneNumber").build());
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).withSenderInfo(SenderInfoBuilder.newSenderInfo(this.senderEmail).withName("firstName", "lastName").withTitle("title").withCompany("company")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.senderEmail).onPage(0).atPosition(100.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        String senderAuthenticationToken = this.eslClient.getAuthenticationTokensService().createSenderAuthenticationToken(this.packageId.getId());
        this.generatedLinkToDesignerForSender = this.authenticationClient.buildRedirectToDesignerForSender(senderAuthenticationToken, this.packageId.getId());
        logger.info(this.generatedLinkToDesignerForSender);
    }
}

