/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.FieldCondition;
import com.silanis.esl.sdk.FieldId;
import com.silanis.esl.sdk.ReferencedConditions;
import com.silanis.esl.sdk.SignatureId;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.FieldConditionBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import org.joda.time.DateTime;

public class PackageReferencedConditionsExample
extends SDKSample {
    private static final String DOCUMENT_ID_1 = "documentId1";
    private static final String DOCUMENT_ID_2 = "documentId2";
    private final SignatureId signatureId1 = new SignatureId("signatureId1");
    private final SignatureId signatureId2 = new SignatureId("signatureId2");
    private final FieldId fieldId1 = new FieldId("fieldId1");
    private final FieldId fieldId2 = new FieldId("fieldId2");
    private final FieldId fieldId3 = new FieldId("fieldId3");
    private final FieldId fieldId4 = new FieldId("fieldId4");
    private final FieldId fieldId5 = new FieldId("fieldId5");
    private final FieldId fieldId6 = new FieldId("fieldId6");
    public ReferencedConditions packageLevelRefConditions;
    public ReferencedConditions documentLevelRefConditions;
    public ReferencedConditions fieldLevelRefConditions;

    public static void main(String ... args) {
        new PackageReferencedConditionsExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using the eSignLive SDK").expiresAt(DateTime.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("signer1").withFirstName("firstName1").withLastName("lastName1")).withDocument(DocumentBuilder.newDocumentWithName("PackageReferencedConditionsExampleDocument1").fromStream(this.documentInputStream1, DocumentType.PDF).withId(DOCUMENT_ID_1).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0).withId(this.signatureId1).withField(FieldBuilder.textField().withName("field1").withId(this.fieldId1).atPosition(400.0, 100.0).onPage(0).build()).withField(FieldBuilder.textField().withName("field2").withId(this.fieldId2).atPosition(400.0, 200.0).onPage(0).build()).withField(FieldBuilder.textField().withName("field3").withId(this.fieldId3).atPosition(400.0, 300.0).onPage(0).build()))).withDocument(DocumentBuilder.newDocumentWithName("PackageReferencedConditionsExampleDocument2").fromStream(this.documentInputStream2, DocumentType.PDF).withId(DOCUMENT_ID_2).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 400.0).withId(this.signatureId2).withField(FieldBuilder.textField().withName("field4").withId(this.fieldId4).atPosition(400.0, 100.0).onPage(0).build()).withField(FieldBuilder.textField().withName("field5").withId(this.fieldId5).atPosition(400.0, 200.0).onPage(0).build()).withField(FieldBuilder.textField().withName("field6").withId(this.fieldId6).atPosition(400.0, 300.0).onPage(0).build()))).withCondition(this.createCondition("condition1", DOCUMENT_ID_1, this.fieldId1.getId(), DOCUMENT_ID_1, this.fieldId2.getId())).withCondition(this.createCondition("condition2", DOCUMENT_ID_1, this.fieldId1.getId(), DOCUMENT_ID_1, this.fieldId3.getId())).withCondition(this.createCondition("condition3", DOCUMENT_ID_2, this.fieldId4.getId(), DOCUMENT_ID_2, this.fieldId5.getId())).build();
        this.packageId = this.eslClient.createPackageOneStep(superDuperPackage);
        this.packageLevelRefConditions = this.eslClient.getPackageService().getReferencedConditions(this.packageId.getId());
        this.documentLevelRefConditions = this.eslClient.getPackageService().getReferencedConditions(this.packageId.getId(), DOCUMENT_ID_1);
        this.fieldLevelRefConditions = this.eslClient.getPackageService().getReferencedConditions(this.packageId.getId(), DOCUMENT_ID_1, this.fieldId1.getId());
    }

    private FieldCondition createCondition(String id, String conditionDocId, String conditionFieldId, String actionDocId, String actionFieldId) {
        return FieldConditionBuilder.newFieldCondition().withId(id).withCondition(String.format("document['%s'].field['%s'].empty == true", conditionDocId, conditionFieldId)).withAction(String.format("document['%s'].field['%s'].disabled = false", actionDocId, actionFieldId)).build();
    }
}

