/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.ExtractAnchor;
import com.silanis.esl.sdk.TextAnchor;
import com.silanis.esl.sdk.TextAnchorPosition;

public class TextAnchorConverter {
    private TextAnchor sdkTextAnchor = null;
    private ExtractAnchor extractAnchor = null;

    public TextAnchorConverter(TextAnchor textAnchor) {
        this.sdkTextAnchor = textAnchor;
    }

    public TextAnchorConverter(ExtractAnchor extractAnchor) {
        this.extractAnchor = extractAnchor;
    }

    public ExtractAnchor toAPIExtractAnchor() {
        if (this.sdkTextAnchor == null) {
            return this.extractAnchor;
        }
        ExtractAnchor result = new ExtractAnchor();
        result.safeSetLeftOffset(this.sdkTextAnchor.getXOffset());
        result.safeSetTopOffset(this.sdkTextAnchor.getYOffset());
        result.safeSetText(this.sdkTextAnchor.getAnchorText());
        result.safeSetIndex(this.sdkTextAnchor.getOccurrence());
        result.safeSetCharacterIndex(this.sdkTextAnchor.getCharacter());
        if (null != this.sdkTextAnchor.getPosition()) {
            result.setAnchorPoint(this.sdkTextAnchor.getPosition().toString());
        }
        result.safeSetWidth(this.sdkTextAnchor.getWidth());
        result.safeSetHeight(this.sdkTextAnchor.getHeight());
        return result;
    }

    public TextAnchor toSDKTextAnchor() {
        if (this.extractAnchor == null) {
            return this.sdkTextAnchor;
        }
        TextAnchor result = new TextAnchor();
        result.setPosition(TextAnchorPosition.valueOf(this.extractAnchor.getAnchorPoint()));
        if (this.extractAnchor.getIndex() != null) {
            result.setOccurrence(this.extractAnchor.getIndex());
        }
        result.setAnchorText(this.extractAnchor.getText());
        if (this.extractAnchor.getCharacterIndex() != null) {
            result.setCharacter(this.extractAnchor.getCharacterIndex());
        }
        if (this.extractAnchor.getLeftOffset() != null) {
            result.setXOffset(this.extractAnchor.getLeftOffset());
        }
        if (this.extractAnchor.getTopOffset() != null) {
            result.setYOffset(this.extractAnchor.getTopOffset());
        }
        if (this.extractAnchor.getWidth() != null) {
            result.setWidth(this.extractAnchor.getWidth());
        }
        if (this.extractAnchor.getHeight() != null) {
            result.setHeight(this.extractAnchor.getHeight());
        }
        return result;
    }
}

