/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.Result;
import com.silanis.esl.api.model.Template;
import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.Direction;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.DocumentConverter;
import com.silanis.esl.sdk.internal.converter.DocumentPackageConverter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class LayoutService {
    private UrlTemplate template;
    private RestClient client;

    public LayoutService(RestClient restClient, String baseUrl) {
        this.client = restClient;
        this.template = new UrlTemplate(baseUrl);
    }

    public String createLayout(DocumentPackage layout) {
        String path = this.template.urlFor("/layouts").build();
        Package layoutToCreate = new DocumentPackageConverter(layout).toAPIPackage();
        for (Document document : layout.getDocuments()) {
            layoutToCreate.addDocument(new DocumentConverter(document).toAPIDocument(layoutToCreate));
        }
        String packageString = Serialization.toJson(layoutToCreate);
        Template template = Serialization.fromJson(packageString, Template.class);
        template.setId(layout.getId().getId());
        String templateString = Serialization.toJson(template);
        try {
            String response = this.client.post(path, templateString);
            Package aPackage = Serialization.fromJson(response, Package.class);
            return aPackage.getId();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create layout.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create layout. Exception: " + e.getMessage());
        }
    }

    public DocumentPackage createAndGetLayout(DocumentPackage layout) {
        String path = this.template.urlFor("/layouts").build();
        Package layoutToCreate = new DocumentPackageConverter(layout).toAPIPackage();
        for (Document document : layout.getDocuments()) {
            layoutToCreate.addDocument(new DocumentConverter(document).toAPIDocument(layoutToCreate));
        }
        String packageString = Serialization.toJson(layoutToCreate);
        Template template = Serialization.fromJson(packageString, Template.class);
        template.setId(layout.getId().getId());
        String templateString = Serialization.toJson(template);
        try {
            String response = this.client.post(path, templateString);
            Package aPackage = Serialization.fromJson(response, Package.class);
            return new DocumentPackageConverter(aPackage).toSDKPackage();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create layout.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create layout. Exception: " + e.getMessage());
        }
    }

    public List<DocumentPackage> getLayouts(Direction direction, PageRequest request) {
        String path = this.template.urlFor("/layouts?to={to}&from={from}&dir={dir}").replace("{dir}", direction.getDirection()).replace("{from}", Integer.toString(request.getFrom())).replace("{to}", Integer.toString(request.to())).build();
        try {
            String response = this.client.get(path);
            Result<Package> results = JacksonUtil.deserialize(response, new TypeReference<Result<Package>>(){});
            ArrayList<DocumentPackage> layouts = new ArrayList<DocumentPackage>();
            for (Package layout : results.getResults()) {
                layouts.add(new DocumentPackageConverter(layout).toSDKPackage());
            }
            return layouts;
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get list of layouts.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get list of layouts. Exception: " + e.getMessage());
        }
    }

    public void applyLayout(PackageId packageId, String documentId, String layoutId) {
        String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/layout?layoutId={layoutId}").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).replace("{layoutId}", layoutId).build();
        try {
            this.client.post(path, "");
        }
        catch (RequestException e) {
            throw new EslServerException("Could not apply layout.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not apply layout. Exception: " + e.getMessage());
        }
    }

    public void applyLayoutByName(PackageId packageId, String documentId, String layoutName) {
        try {
            String path = this.template.urlFor("/packages/{packageId}/documents/{documentId}/layout?layoutName={layoutName}").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).replace("{layoutName}", URLEncoder.encode(layoutName, "UTF-8")).build();
            this.client.post(path, "");
        }
        catch (UnsupportedEncodingException e) {
            throw new EslException("Layout name : '" + layoutName + "' can not be url encoded.", e);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not apply layout.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not apply layout. Exception: " + e.getMessage());
        }
    }
}

