/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.EventNotificationConfig;
import com.silanis.esl.sdk.NotificationEvent;
import java.util.HashSet;
import java.util.Set;

public final class EventNotificationConfigBuilder {
    private String url;
    private String key;
    private Set<NotificationEvent> events;

    private EventNotificationConfigBuilder(String url) {
        this(url, "");
    }

    private EventNotificationConfigBuilder(String url, String key) {
        this.url = url;
        this.key = key;
        this.events = new HashSet<NotificationEvent>();
    }

    public static EventNotificationConfigBuilder newEventNotificationConfig(String url) {
        return new EventNotificationConfigBuilder(url);
    }

    public EventNotificationConfigBuilder withKey(String key) {
        this.key = key;
        return this;
    }

    public EventNotificationConfigBuilder forEvent(NotificationEvent event) {
        this.events.add(event);
        return this;
    }

    public EventNotificationConfigBuilder setEvents(Set<NotificationEvent> events) {
        this.events = events;
        return this;
    }

    public EventNotificationConfig build() {
        EventNotificationConfig result = new EventNotificationConfig(this.url);
        result.setKey(this.key);
        result.getEvents().addAll(this.events);
        return result;
    }
}

