/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.SenderStatus;
import com.silanis.esl.sdk.builder.AccountMemberBuilder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SenderInfoBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CreateTemplateOnBehalfOfAnotherSenderExample
extends SDKSample {
    public PackageId templateId;
    public static final String SENDER_FIRST_NAME = "Rob";
    public static final String SENDER_LAST_NAME = "Mason";
    public static final String SENDER_TITLE = "Chief Vizier";
    public static final String SENDER_COMPANY = "The Masons";

    public static void main(String ... args) {
        new CreateTemplateOnBehalfOfAnotherSenderExample().run();
    }

    @Override
    public void execute() {
        this.senderEmail = this.getRandomEmail();
        this.eslClient.getAccountService().inviteUser(AccountMemberBuilder.newAccountMember(this.senderEmail).withFirstName("firstName").withLastName("lastName").withCompany("company").withTitle("title").withPhoneNumber("phoneNumber").withStatus(SenderStatus.ACTIVE).build());
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using the eSignLive SDK").withEmailMessage("This message should be delivered to all signers").withSenderInfo(SenderInfoBuilder.newSenderInfo(this.senderEmail).withName(SENDER_FIRST_NAME, SENDER_LAST_NAME).withTitle(SENDER_TITLE).withCompany(SENDER_COMPANY)).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("Patty").withLastName("Galant")).withDocument(DocumentBuilder.newDocumentWithName("First Document").withId("documentId").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.senderEmail).atPosition(200.0, 200.0).onPage(0)).withSignature(SignatureBuilder.signatureFor(this.email1).atPosition(200.0, 400.0).onPage(0))).build();
        this.templateId = this.eslClient.getTemplateService().createTemplate(superDuperPackage);
        DocumentPackage packageFromTemplate = PackageBuilder.newPackageNamed("PackageFromTemplateOnBehalfOfSender" + new SimpleDateFormat("HH:mm:ss").format(new Date())).withSenderInfo(SenderInfoBuilder.newSenderInfo(this.senderEmail).withName(SENDER_FIRST_NAME, SENDER_LAST_NAME).withTitle(SENDER_TITLE).withCompany(SENDER_COMPANY)).withDocument(DocumentBuilder.newDocumentWithName("Second Document").withId("documentId2").fromStream(this.documentInputStream2, DocumentType.PDF)).build();
        this.packageId = this.eslClient.getTemplateService().createPackageFromTemplate(this.templateId, packageFromTemplate);
    }
}

