/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentId;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import org.joda.time.DateMidnight;

public class DeleteDocumentsExample
extends SDKSample {
    public DocumentPackage retrievedPackageWithDeletedDocuments;
    public static final String DOCUMENT1_NAME = "First Document";
    public static final String DOCUMENT2_NAME = "Second Document";
    public static final String DOCUMENT1_ID = "doc1";
    public static final String DOCUMENT2_ID = "doc2";

    public static void main(String ... args) {
        new DeleteDocumentsExample().run();
    }

    @Override
    protected void execute() {
        DocumentPackage builtPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package demonstrating document upload").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCompany("Acme Inc.")).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT1_NAME).fromStream(this.documentInputStream1, DocumentType.PDF).withId(DOCUMENT1_ID).withSignature(SignatureBuilder.signatureFor(this.email1).atPosition(100.0, 100.0).onPage(0).withField(FieldBuilder.textField().onPage(0).atPosition(200.0, 200.0))).withDescription("Document description").build()).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT2_NAME).fromStream(this.documentInputStream2, DocumentType.PDF).withId(DOCUMENT2_ID).withSignature(SignatureBuilder.signatureFor(this.email1).atPosition(100.0, 100.0).onPage(0).withField(FieldBuilder.textField().onPage(0).atPosition(200.0, 200.0))).withDescription("Document description2").build()).build();
        this.packageId = this.eslClient.createPackage(builtPackage);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        this.eslClient.getPackageService().deleteDocuments(this.packageId, new DocumentId(DOCUMENT1_ID), new DocumentId(DOCUMENT2_ID));
        this.retrievedPackageWithDeletedDocuments = this.eslClient.getPackage(this.packageId);
    }
}

