/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.PackageStatus;
import com.silanis.esl.sdk.Page;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.Date;
import org.joda.time.DateTime;

public class GetCompletedPackagesWithinDateRangeExample
extends SDKSample {
    public static final Date START_DATE = new DateTime().toDate();
    public static final Date END_DATE = new DateTime().toDate();
    public Page<DocumentPackage> draftPackages;
    public Page<DocumentPackage> sentPackages;
    public Page<DocumentPackage> declinedPackages;
    public Page<DocumentPackage> archivedPackages;
    public Page<DocumentPackage> completedPackages;

    public static void main(String ... args) {
        new GetCompletedPackagesWithinDateRangeExample().run();
    }

    @Override
    public void execute() {
        this.draftPackages = this.getPackagesByPackageStatus(PackageStatus.DRAFT, START_DATE, END_DATE);
        this.sentPackages = this.getPackagesByPackageStatus(PackageStatus.SENT, START_DATE, END_DATE);
        this.declinedPackages = this.getPackagesByPackageStatus(PackageStatus.DECLINED, START_DATE, END_DATE);
        this.archivedPackages = this.getPackagesByPackageStatus(PackageStatus.ARCHIVED, START_DATE, END_DATE);
        this.completedPackages = this.getPackagesByPackageStatus(PackageStatus.COMPLETED, START_DATE, END_DATE);
        System.out.format("PackageStatus : %s, The number of pakcages : %d%n", PackageStatus.DRAFT, this.draftPackages.getNumberOfElements());
        System.out.format("PackageStatus : %s, The number of pakcages : %d%n", PackageStatus.SENT, this.sentPackages.getNumberOfElements());
        System.out.format("PackageStatus : %s, The number of pakcages : %d%n", PackageStatus.DECLINED, this.declinedPackages.getNumberOfElements());
        System.out.format("PackageStatus : %s, The number of pakcages : %d%n", PackageStatus.ARCHIVED, this.archivedPackages.getNumberOfElements());
        System.out.format("PackageStatus : %s, The number of pakcages : %d%n", PackageStatus.COMPLETED, this.completedPackages.getNumberOfElements());
    }

    private Page<DocumentPackage> getPackagesByPackageStatus(PackageStatus packageStatus, Date startDate, Date endDate) {
        Page<DocumentPackage> resultPage = this.eslClient.getPackageService().getUpdatedPackagesWithinDateRange(packageStatus, new PageRequest(1), startDate, endDate);
        return resultPage;
    }
}

