/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Placeholder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TemplateExample
extends SDKSample {
    private DocumentPackage retrievedTemplate;
    public PackageId templateId;
    public PackageId instantiatedTemplateId;
    public static final String DOCUMENT_NAME = "First Document";
    public static final String DOCUMENT_ID = "doc1";
    public static final String TEMPLATE_NAME = "TemplateExample: " + new SimpleDateFormat("HH:mm:ss").format(new Date());
    public static final String TEMPLATE_DESCRIPTION = "This is a package created using the eSignLive SDK";
    public static final String TEMPLATE_EMAIL_MESSAGE = "This message should be delivered to all signers";
    public static final String TEMPLATE_SIGNER1_FIRST = "John";
    public static final String TEMPLATE_SIGNER1_LAST = "Smith";
    public static final String TEMPLATE_SIGNER2_FIRST = "Patty";
    public static final String TEMPLATE_SIGNER2_LAST = "Galant";
    public static final String PLACEHOLDER_ID = "PlaceholderId1";
    public static final String UPDATED_TEMPLATE_NAME = "Modified Template Name : " + new SimpleDateFormat("HH:mm:ss").format(new Date());
    public static final String UPDATED_TEMPLATE_DESCRIPTION = "Modified Template description";

    public DocumentPackage getRetrievedTemplate() {
        return this.retrievedTemplate;
    }

    public static void main(String ... args) {
        new TemplateExample().run();
    }

    @Override
    public void execute() {
        Document document = DocumentBuilder.newDocumentWithName(DOCUMENT_NAME).withId(DOCUMENT_ID).fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(new Placeholder(PLACEHOLDER_ID)).onPage(0).atPosition(100.0, 100.0)).build();
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(TEMPLATE_NAME).describedAs(TEMPLATE_DESCRIPTION).withEmailMessage(TEMPLATE_EMAIL_MESSAGE).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName(TEMPLATE_SIGNER1_FIRST).withLastName(TEMPLATE_SIGNER1_LAST)).withSigner(SignerBuilder.newSignerWithEmail(this.email2).withFirstName(TEMPLATE_SIGNER2_FIRST).withLastName(TEMPLATE_SIGNER2_LAST)).withSigner(SignerBuilder.newSignerPlaceholder(new Placeholder(PLACEHOLDER_ID))).withDocument(document).build();
        this.templateId = this.eslClient.getTemplateService().createTemplate(superDuperPackage);
        this.retrievedTemplate = this.eslClient.getPackage(this.templateId);
        this.retrievedTemplate.setName(UPDATED_TEMPLATE_NAME);
        this.retrievedTemplate.setDescription(UPDATED_TEMPLATE_DESCRIPTION);
        this.eslClient.getTemplateService().updateTemplate(this.retrievedTemplate);
        this.retrievedTemplate = this.eslClient.getPackage(this.templateId);
        this.instantiatedTemplateId = this.eslClient.createPackageFromTemplate(this.templateId, PackageBuilder.newPackageNamed(this.getPackageName()).build());
    }
}

