/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Placeholder;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UpdateTemplateWithPlaceholderExample
extends SDKSample {
    public PackageId templateId;
    public static final String DOCUMENT_NAME = "First Document";
    public static final String DOCUMENT_ID = "doc1";
    public static final String TEMPLATE_NAME = "UpdateTemplateWithPlaceholderExample Template: " + new SimpleDateFormat("HH:mm:ss").format(new Date());
    public static final String TEMPLATE_DESCRIPTION = "This is a template created using the eSignLive SDK";
    public static final String TEMPLATE_EMAIL_MESSAGE = "This message should be delivered to all signers";
    public static final String TEMPLATE_SIGNER_FIRST = "John";
    public static final String TEMPLATE_SIGNER_LAST = "Smith";
    public static final String PLACEHOLDER_ID = "PlaceholderId1";
    public static final String PLACEHOLDER2_ID = "PlaceholderId2";
    public DocumentPackage retrievedTemplate;
    public DocumentPackage updatedTemplate;

    public static void main(String ... args) {
        new UpdateTemplateWithPlaceholderExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage template = PackageBuilder.newPackageNamed(TEMPLATE_NAME).describedAs(TEMPLATE_DESCRIPTION).withEmailMessage(TEMPLATE_EMAIL_MESSAGE).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName(TEMPLATE_SIGNER_FIRST).withLastName(TEMPLATE_SIGNER_LAST)).withSigner(SignerBuilder.newSignerPlaceholder(new Placeholder(PLACEHOLDER_ID))).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT_NAME).withId(DOCUMENT_ID).fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0)).withSignature(SignatureBuilder.signatureFor(new Placeholder(PLACEHOLDER_ID)).onPage(0).atPosition(400.0, 100.0))).build();
        this.templateId = this.eslClient.getTemplateService().createTemplate(template);
        this.retrievedTemplate = this.eslClient.getPackage(this.templateId);
        this.eslClient.getTemplateService().addPlaceholder(this.templateId, new Placeholder(PLACEHOLDER2_ID));
        this.updatedTemplate = this.eslClient.getPackage(this.templateId);
        Signature newSignature = SignatureBuilder.signatureFor(new Placeholder(PLACEHOLDER2_ID)).onPage(0).atPosition(400.0, 300.0).build();
        this.eslClient.getApprovalService().addSignature(this.updatedTemplate, DOCUMENT_ID, newSignature);
        this.updatedTemplate = this.eslClient.getPackage(this.templateId);
    }
}

