/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.silanis.esl.sdk.AttachmentFile;
import com.silanis.esl.sdk.AttachmentRequirement;
import com.silanis.esl.sdk.internal.converter.AttachmentFileConverter;
import com.silanis.esl.sdk.internal.converter.RequirementStatusConverter;
import java.util.List;
import java.util.Map;

public class AttachmentRequirementConverter {
    private AttachmentRequirement sdkAttachmentRequirement = null;
    private com.silanis.esl.api.model.AttachmentRequirement apiAttachmentRequirement = null;

    public AttachmentRequirementConverter(com.silanis.esl.api.model.AttachmentRequirement apiAttachmentRequirement) {
        this.apiAttachmentRequirement = apiAttachmentRequirement;
    }

    public AttachmentRequirementConverter(AttachmentRequirement sdkAttachmentRequirement) {
        this.sdkAttachmentRequirement = sdkAttachmentRequirement;
    }

    public com.silanis.esl.api.model.AttachmentRequirement toAPIAttachmentRequirement() {
        if (this.sdkAttachmentRequirement == null) {
            return this.apiAttachmentRequirement;
        }
        com.silanis.esl.api.model.AttachmentRequirement result = new com.silanis.esl.api.model.AttachmentRequirement();
        if (this.sdkAttachmentRequirement.getId() != null && !this.sdkAttachmentRequirement.getId().isEmpty()) {
            result.setId(this.sdkAttachmentRequirement.getId());
        }
        result.setName(this.sdkAttachmentRequirement.getName());
        result.setComment(this.sdkAttachmentRequirement.getSenderComment());
        result.setData((Map)this.sdkAttachmentRequirement.getData());
        result.setDescription(this.sdkAttachmentRequirement.getDescription());
        result.setRequired(this.sdkAttachmentRequirement.isRequired());
        result.setFiles(this.getApiAttachmentFiles());
        if (this.sdkAttachmentRequirement.getStatus() == null) {
            result.setStatus("INCOMPLETE");
        } else {
            result.setStatus(new RequirementStatusConverter(this.sdkAttachmentRequirement.getStatus()).toAPIRequirementStatus());
        }
        return result;
    }

    public AttachmentRequirement toSDKAttachmentRequirement() {
        if (this.apiAttachmentRequirement == null) {
            return this.sdkAttachmentRequirement;
        }
        if (this.apiAttachmentRequirement.getName() != null) {
            AttachmentRequirement result = new AttachmentRequirement(this.apiAttachmentRequirement.getName());
            result.setSenderComment(this.apiAttachmentRequirement.getComment());
            result.setData(this.apiAttachmentRequirement.getData());
            result.setDescription(this.apiAttachmentRequirement.getDescription());
            result.setId(this.apiAttachmentRequirement.getId());
            result.setRequired(this.apiAttachmentRequirement.getRequired());
            result.setStatus(new RequirementStatusConverter(this.apiAttachmentRequirement.getStatus()).toSDKRequirementStatus());
            result.setFiles(this.getSdkAttachmentFiles());
            return result;
        }
        return this.sdkAttachmentRequirement;
    }

    private List<AttachmentFile> getSdkAttachmentFiles() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.apiAttachmentRequirement.getFiles(), (Function)new Function<com.silanis.esl.api.model.AttachmentFile, AttachmentFile>(){

            public AttachmentFile apply(com.silanis.esl.api.model.AttachmentFile attachmentFile) {
                return new AttachmentFileConverter(attachmentFile).toSDKAttachmentFile();
            }
        }));
    }

    private List<com.silanis.esl.api.model.AttachmentFile> getApiAttachmentFiles() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.sdkAttachmentRequirement.getFiles(), (Function)new Function<AttachmentFile, com.silanis.esl.api.model.AttachmentFile>(){

            public com.silanis.esl.api.model.AttachmentFile apply(AttachmentFile attachmentFile) {
                return new AttachmentFileConverter(attachmentFile).toApiAttachmentFile();
            }
        }));
    }
}

