/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.sdk.AccountRole;
import com.silanis.esl.sdk.UserAccountRole;
import com.silanis.esl.sdk.internal.converter.AccountRoleConverter;
import java.util.ArrayList;
import java.util.List;

public class UserAccountRoleConverter {
    private final Optional<UserAccountRole> sdkUserAccountRoleOptional;
    private final Optional<com.silanis.esl.api.model.UserAccountRole> apiUserAccountRoleOptional;

    public UserAccountRoleConverter(UserAccountRole sdkAccountRoleOptional) {
        this.sdkUserAccountRoleOptional = Optional.fromNullable((Object)sdkAccountRoleOptional);
        this.apiUserAccountRoleOptional = Optional.absent();
    }

    public UserAccountRoleConverter(com.silanis.esl.api.model.UserAccountRole apiUserAccountRoleOptional) {
        this.apiUserAccountRoleOptional = Optional.fromNullable((Object)apiUserAccountRoleOptional);
        this.sdkUserAccountRoleOptional = Optional.absent();
    }

    public UserAccountRole toSDKUserAccountRole() {
        if (this.apiUserAccountRoleOptional.isPresent()) {
            com.silanis.esl.api.model.UserAccountRole role = (com.silanis.esl.api.model.UserAccountRole)this.apiUserAccountRoleOptional.get();
            return new UserAccountRole(role.getUserId(), role.getAccountId(), this.toSDKAccountRoles(role.getAccountRoles()));
        }
        return this.sdkUserAccountRoleOptional.isPresent() ? (UserAccountRole)this.sdkUserAccountRoleOptional.get() : null;
    }

    public com.silanis.esl.api.model.UserAccountRole toAPIUserAccountRole() {
        if (this.sdkUserAccountRoleOptional.isPresent()) {
            UserAccountRole role = (UserAccountRole)this.sdkUserAccountRoleOptional.get();
            return new com.silanis.esl.api.model.UserAccountRole(role.getUserId(), role.getAccountId(), this.toAPIAccountRoles(role.getAccountRoles()));
        }
        return this.apiUserAccountRoleOptional.isPresent() ? (com.silanis.esl.api.model.UserAccountRole)this.apiUserAccountRoleOptional.get() : null;
    }

    private List<com.silanis.esl.api.model.AccountRole> toAPIAccountRoles(List<AccountRole> sdkAccountRoles) {
        ArrayList<com.silanis.esl.api.model.AccountRole> accountRoles = new ArrayList<com.silanis.esl.api.model.AccountRole>();
        for (AccountRole sdkAccountRole : sdkAccountRoles) {
            accountRoles.add(new AccountRoleConverter(sdkAccountRole).toAPIAccountRole());
        }
        return accountRoles;
    }

    private List<AccountRole> toSDKAccountRoles(List<com.silanis.esl.api.model.AccountRole> apiAccountRoles) {
        ArrayList<AccountRole> sdkAccountRoles = new ArrayList<AccountRole>();
        for (com.silanis.esl.api.model.AccountRole apiAccountRole : apiAccountRoles) {
            sdkAccountRoles.add(new AccountRoleConverter(apiAccountRole).toSDKAccountRole());
        }
        return sdkAccountRoles;
    }
}

