/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk;

import com.silanis.esl.sdk.AttachmentRequirement;
import com.silanis.esl.sdk.Authentication;
import com.silanis.esl.sdk.AuthenticationMethod;
import com.silanis.esl.sdk.Challenge;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.KnowledgeBasedAuthentication;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;

public class Signer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String email;
    private final GroupId groupId;
    private final String firstName;
    private final String lastName;
    private final Authentication authentication;
    private int signingOrder;
    private String title;
    private String company;
    private String signerType;
    private Locale language;
    private boolean canChangeSigner;
    private String message;
    private boolean deliverSignedDocumentsByEmail;
    private String id;
    private String placeholderName;
    private boolean locked;
    private List<AttachmentRequirement> attachments;
    private KnowledgeBasedAuthentication knowledgeBasedAuthentication;
    private String localLanguage;

    public Signer(String email, String firstName, String lastName, Authentication authentication) {
        this.email = email == null ? email : email.toLowerCase();
        this.firstName = firstName;
        this.lastName = lastName;
        this.authentication = authentication;
        this.groupId = null;
    }

    public Signer(GroupId groupId) {
        this.email = null;
        this.firstName = null;
        this.lastName = null;
        this.authentication = new Authentication(AuthenticationMethod.EMAIL);
        this.groupId = groupId;
    }

    public Signer(String id) {
        this.email = null;
        this.firstName = null;
        this.lastName = null;
        this.authentication = new Authentication(AuthenticationMethod.EMAIL);
        this.groupId = null;
        this.id = id;
    }

    public boolean isGroupSigner() {
        return this.groupId != null;
    }

    public boolean isPlaceholderSigner() {
        return this.groupId == null && this.email == null;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setSigningOrder(int signingOrder) {
        this.signingOrder = signingOrder;
    }

    public int getSigningOrder() {
        return this.signingOrder;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authentication.getMethod();
    }

    public List<Challenge> getChallengeQuestions() {
        return this.authentication.getChallenges();
    }

    public String getPhoneNumber() {
        return this.authentication.getPhoneNumber();
    }

    public String getTitle() {
        return this.title;
    }

    public String getCompany() {
        return this.company;
    }

    public String getSignerType() {
        return this.signerType;
    }

    public void setSignerType(String signerType) {
        this.signerType = signerType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public void setCanChangeSigner(boolean canChangeSigner) {
        this.canChangeSigner = canChangeSigner;
    }

    public boolean canChangeSigner() {
        return this.canChangeSigner;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setDeliverSignedDocumentsByEmail(boolean deliverSignedDocumentsByEmail) {
        this.deliverSignedDocumentsByEmail = deliverSignedDocumentsByEmail;
    }

    public boolean isDeliverSignedDocumentsByEmail() {
        return this.deliverSignedDocumentsByEmail;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public GroupId getGroupId() {
        return this.groupId;
    }

    public String getPlaceholderName() {
        return this.placeholderName;
    }

    public void setPlaceholderName(String placeholderName) {
        this.placeholderName = placeholderName;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public List<AttachmentRequirement> getAttachmentRequirements() {
        return this.attachments;
    }

    public AttachmentRequirement getAttachmentRequirement(String attachmentName) {
        for (AttachmentRequirement attachment : this.attachments) {
            if (!attachment.getName().equals(attachmentName)) continue;
            return attachment;
        }
        return null;
    }

    public void setAttachmentRequirements(List<AttachmentRequirement> attachments) {
        this.attachments = attachments;
    }

    public void addAttachmentRequirement(AttachmentRequirement attachment) {
        this.attachments.add(attachment);
    }

    public KnowledgeBasedAuthentication getKnowledgeBasedAuthentication() {
        return this.knowledgeBasedAuthentication;
    }

    public void setKnowledgeBasedAuthentication(KnowledgeBasedAuthentication knowledgeBasedAuthentication) {
        this.knowledgeBasedAuthentication = knowledgeBasedAuthentication;
    }

    public String getLocalLanguage() {
        return this.localLanguage;
    }

    public void setLocalLanguage(String localLanguage) {
        this.localLanguage = localLanguage;
    }
}

