/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.CcExpiration;
import com.silanis.esl.sdk.CreditCard;

public class CreditCardBuilder {
    private String cvv;
    private CcExpiration expiration;
    private String name;
    private String number;
    private String type;

    private CreditCardBuilder() {
    }

    public static CreditCardBuilder newCreditCard() {
        return new CreditCardBuilder();
    }

    public CreditCardBuilder withCvv(String cvv) {
        this.cvv = cvv;
        return this;
    }

    public CreditCardBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public CreditCardBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public CreditCardBuilder withNumber(String number) {
        this.number = number;
        return this;
    }

    public CreditCardBuilder withExpiration(CcExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    public CreditCardBuilder withExpiration(Integer month, Integer year) {
        this.expiration = new CcExpiration();
        this.expiration.setMonth(month);
        this.expiration.setYear(year);
        return this;
    }

    public CreditCard build() {
        CreditCard creditCard = new CreditCard();
        creditCard.setCvv(this.cvv);
        creditCard.setName(this.name);
        creditCard.setNumber(this.number);
        creditCard.setType(this.type);
        creditCard.setExpiration(this.expiration);
        return creditCard;
    }
}

