/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.EslClient;
import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.apitoken.ApiTokenConfig;
import com.silanis.esl.sdk.oauth.OAuthTokenConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public class EslClientBuilder {
    private Map<String, String> additionalHeaders = Collections.emptyMap();
    private ProxyConfiguration proxyConfiguration;
    private Properties props;
    private String authType;

    private EslClientBuilder() {
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public String getAuthType() {
        return this.authType;
    }

    public static EslClientBuilder newEslClientBuilder() {
        return new EslClientBuilder();
    }

    public EslClientBuilder withAuthenticationType(String authType) {
        this.authType = authType;
        return this;
    }

    public EslClientBuilder withProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        return this;
    }

    public EslClientBuilder withAdditionalHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    public EslClientBuilder withProperties(Properties props) {
        this.props = props;
        return this;
    }

    public EslClient build() {
        EslClient client;
        String authType = this.props.getProperty("api.auth.type");
        if ("APIKEY".equalsIgnoreCase(authType) || this.props.getProperty("api.clientId") == null && this.props.getProperty("api.oauth.clientID") == null) {
            client = this.buildEslClientForAPIKEY(this.additionalHeaders, this.proxyConfiguration);
        } else if ("APITOKEN".equalsIgnoreCase(authType) || this.props.getProperty("api.oauth.clientID") == null) {
            client = this.buildEslClientForAPITOKEN(this.additionalHeaders, this.proxyConfiguration);
        } else if ("OAUTH".equalsIgnoreCase(authType) || this.props.getProperty("api.oauth.clientID") != null) {
            client = this.buildEslClientForOAuth(this.additionalHeaders, this.proxyConfiguration);
        } else {
            throw new RuntimeException("Unknow Authentication Method.");
        }
        return client;
    }

    private EslClient buildEslClientForOAuth(Map<String, String> additionalHeaders, ProxyConfiguration proxyConfiguration) {
        OAuthTokenConfig oAuthTokenConfig = OAuthTokenConfig.builder().withClientId(this.props.getProperty("api.oauth.clientID")).withClientSecret(this.props.getProperty("api.oauth.clientSecret")).withAuthenticationServer(this.props.getProperty("api.oauth.server.url")).build();
        return new EslClient(oAuthTokenConfig, this.props.getProperty("api.url"), true, proxyConfiguration, true, additionalHeaders);
    }

    private EslClient buildEslClientForAPITOKEN(Map<String, String> additionalHeaders, ProxyConfiguration proxyConfiguration) {
        ApiTokenConfig apiTokenConfig = ApiTokenConfig.newBuilder().clientAppId(this.props.getProperty("api.clientId")).clientAppSecret(this.props.getProperty("api.secret")).tokenType(ApiTokenConfig.TokenType.OWNER).baseUrl(this.props.getProperty("webpage.url")).build();
        return new EslClient(apiTokenConfig, this.props.getProperty("api.url"), true, proxyConfiguration, true, additionalHeaders);
    }

    private EslClient buildEslClientForAPIKEY(Map<String, String> additionalHeaders, ProxyConfiguration proxyConfiguration) {
        return new EslClient(this.props.getProperty("api.key"), this.props.getProperty("api.url"), true, proxyConfiguration).setWebpageURL(this.props.getProperty("webpage.url"));
    }
}

