/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.FieldId;
import com.silanis.esl.sdk.FieldStyle;
import com.silanis.esl.sdk.FieldValidator;
import com.silanis.esl.sdk.TextAnchor;
import com.silanis.esl.sdk.builder.BuilderException;
import com.silanis.esl.sdk.builder.FieldValidatorBuilder;
import com.silanis.esl.sdk.builder.TextAnchorBuilder;

public class FieldBuilder {
    public static final int DEFAULT_WIDTH = 200;
    public static final int DEFAULT_HEIGHT = 50;
    public static final FieldStyle DEFAULT_STYLE = FieldStyle.UNBOUND_TEXT_FIELD;
    public static final String SELECTED_VALUE = "X";
    public static final String CHECKBOX_CHECKED = "X";
    public static final String RADIO_SELECTED = "X";
    private int pageNumber;
    private double x;
    private double y;
    private double width = 200.0;
    private double height = 50.0;
    private FieldStyle style = DEFAULT_STYLE;
    private String name;
    private boolean extract;
    private FieldValidator fieldValidator;
    private String value;
    private FieldId fieldId;
    private TextAnchor textAnchor;
    private Integer fontSize;
    private String tooltip;

    public static FieldBuilder newField() {
        return new FieldBuilder();
    }

    public static FieldBuilder signatureDate() {
        return new FieldBuilder().withStyle(FieldStyle.BOUND_DATE);
    }

    public static FieldBuilder signerName() {
        return new FieldBuilder().withStyle(FieldStyle.BOUND_NAME);
    }

    public static FieldBuilder signerTitle() {
        return new FieldBuilder().withStyle(FieldStyle.BOUND_TITLE);
    }

    public static FieldBuilder signerCompany() {
        return new FieldBuilder().withStyle(FieldStyle.BOUND_COMPANY);
    }

    public static FieldBuilder textField() {
        return new FieldBuilder().withStyle(FieldStyle.UNBOUND_TEXT_FIELD);
    }

    public static FieldBuilder customField(String name) {
        return new FieldBuilder().withStyle(FieldStyle.UNBOUND_CUSTOM_FIELD).withName(name);
    }

    public static FieldBuilder checkBox() {
        return new FieldBuilder().withStyle(FieldStyle.UNBOUND_CHECK_BOX);
    }

    public static FieldBuilder radioButton(String group) {
        if (group == null) {
            throw new BuilderException("Radio button must have a group.");
        }
        return new FieldBuilder().withStyle(FieldStyle.UNBOUND_RADIO_BUTTON).withValidation(FieldValidatorBuilder.basic().withOption(group));
    }

    public static FieldBuilder dropList() {
        return new FieldBuilder().withStyle(FieldStyle.DROP_LIST);
    }

    public static FieldBuilder textArea() {
        return new FieldBuilder().withStyle(FieldStyle.TEXT_AREA);
    }

    public static FieldBuilder label() {
        return new FieldBuilder().withStyle(FieldStyle.LABEL);
    }

    public static FieldBuilder datepicker() {
        return new FieldBuilder().withStyle(FieldStyle.DATEPICKER);
    }

    public static FieldBuilder qrCode() {
        return new FieldBuilder().withStyle(FieldStyle.BOUND_QRCODE).withSize(77.0, 77.0);
    }

    public FieldBuilder onPage(int pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public FieldBuilder atPosition(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public FieldBuilder withSize(double width, double height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public FieldBuilder withStyle(FieldStyle style) {
        this.style = style;
        return this;
    }

    public FieldBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public FieldBuilder withPositionExtracted() {
        this.extract = true;
        return this;
    }

    public FieldBuilder withPositionAnchor(TextAnchorBuilder builder) {
        return this.withPositionAnchor(builder.build());
    }

    public FieldBuilder withPositionAnchor(TextAnchor textAnchor) {
        this.textAnchor = textAnchor;
        return this;
    }

    public FieldBuilder withValidation(FieldValidator fieldValidator) {
        this.mergeValidation(fieldValidator);
        return this;
    }

    public FieldBuilder withValidation(FieldValidatorBuilder builder) {
        return this.withValidation(builder.build());
    }

    private void mergeValidation(FieldValidator fieldValidator) {
        if (null != this.fieldValidator) {
            if (null != fieldValidator.getErrorMessage()) {
                this.fieldValidator.setErrorMessage(fieldValidator.getErrorMessage());
            }
            if (null != fieldValidator.getMaxLength()) {
                this.fieldValidator.setMaxLength(fieldValidator.getMaxLength());
            }
            if (null != fieldValidator.getMinLength()) {
                this.fieldValidator.setMinLength(fieldValidator.getMinLength());
            }
            if (null != fieldValidator.getRegex()) {
                this.fieldValidator.setRegex(fieldValidator.getRegex());
            }
            if (null != fieldValidator.getOptions() && fieldValidator.getOptions().size() > 0) {
                this.fieldValidator.setOptions(fieldValidator.getOptions());
            }
            if (null != fieldValidator.getGroup()) {
                this.fieldValidator.setGroup(fieldValidator.getGroup());
            }
            if (null != fieldValidator.getMinimumRequired()) {
                this.fieldValidator.setMinimumRequired(fieldValidator.getMinimumRequired());
            }
            if (null != fieldValidator.getMaximumRequired()) {
                this.fieldValidator.setMaximumRequired(fieldValidator.getMaximumRequired());
            }
            this.fieldValidator.setRequired(fieldValidator.isRequired());
            this.fieldValidator.setGroupTooltip(fieldValidator.getGroupTooltip());
            this.fieldValidator.setDisabled(fieldValidator.isDisabled());
        } else {
            this.fieldValidator = fieldValidator;
        }
    }

    public FieldBuilder withValue(boolean value) {
        if (this.style == FieldStyle.UNBOUND_CHECK_BOX || this.style == FieldStyle.UNBOUND_RADIO_BUTTON) {
            this.value = value ? "X" : "";
        }
        return this;
    }

    public FieldBuilder withValue(String value) {
        this.value = value;
        return this;
    }

    public FieldBuilder withFontSize(Integer fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public FieldBuilder withTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public FieldBuilder withId(FieldId fieldId) {
        this.fieldId = fieldId;
        return this;
    }

    public Field build() {
        Field field = new Field();
        field.setPage(this.pageNumber);
        field.setX(this.x);
        field.setY(this.y);
        field.setStyle(this.style);
        field.setWidth(this.width);
        field.setHeight(this.height);
        field.setName(this.name);
        field.setExtraction(this.extract);
        field.setFieldValidator(this.fieldValidator);
        field.setValue(this.value);
        field.setFontSize(this.fontSize);
        field.setTooltip(this.tooltip);
        if (this.fieldId != null) {
            field.setId(this.fieldId);
        }
        if (this.textAnchor != null) {
            field.setTextAnchor(this.textAnchor);
        }
        return field;
    }
}

