/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.Handover;
import com.silanis.esl.sdk.builder.BuilderException;
import java.util.Locale;

public class HandoverBuilder {
    private Locale language;
    private String href;
    private String text;
    private String title;

    private HandoverBuilder(Locale language) {
        this.language = language;
    }

    public static HandoverBuilder newHandover(Locale language) {
        if (language == null) {
            throw new BuilderException("Language cannot be null.");
        }
        return new HandoverBuilder(language);
    }

    public HandoverBuilder withHref(String href) {
        this.href = href;
        return this;
    }

    public HandoverBuilder withText(String text) {
        this.text = text;
        return this;
    }

    public HandoverBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public Handover build() {
        Handover handover = new Handover();
        handover.setLanguage(this.language);
        handover.setHref(this.href);
        handover.setText(this.text);
        handover.setTitle(this.title);
        return handover;
    }
}

